/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.trashslot.network;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.trashslot.TrashHelper;
import net.blay09.mods.trashslot.config.TrashSlotConfig;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class MessageTrashSlotClick
implements CustomPacketPayload {
    public static CustomPacketPayload.Type<MessageTrashSlotClick> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"trashslot", (String)"trash_slot_click"));
    public static StreamCodec<RegistryFriendlyByteBuf, MessageTrashSlotClick> CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, it -> it.itemStack, (StreamCodec)ByteBufCodecs.BOOL, it -> it.isRightClick, MessageTrashSlotClick::new);
    private final ItemStack itemStack;
    private final boolean isRightClick;

    public MessageTrashSlotClick(ItemStack itemStack, boolean isRightClick) {
        this.itemStack = itemStack;
        this.isRightClick = isRightClick;
    }

    public static void encode(RegistryFriendlyByteBuf buf, MessageTrashSlotClick message) {
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)message.itemStack);
        buf.writeBoolean(message.isRightClick);
    }

    public static MessageTrashSlotClick decode(RegistryFriendlyByteBuf buf) {
        ItemStack itemStack = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf);
        boolean isRightClick = buf.readBoolean();
        return new MessageTrashSlotClick(itemStack, isRightClick);
    }

    public static void handle(ServerPlayer player, MessageTrashSlotClick message) {
        if (player.isSpectator()) {
            return;
        }
        ItemStack actualMouseItem = player.containerMenu.getCarried();
        ResourceLocation registryName = Balm.getRegistries().getKey(actualMouseItem.getItem());
        if (registryName != null && TrashSlotConfig.getActive().deletionDenyList.contains(registryName.toString())) {
            return;
        }
        if (ItemStack.matches((ItemStack)actualMouseItem, (ItemStack)message.itemStack)) {
            if (actualMouseItem.isEmpty()) {
                ItemStack trashStack = TrashHelper.getTrashItem((Player)player);
                ItemStack mouseStack = message.isRightClick ? trashStack.split(1) : trashStack;
                player.containerMenu.setCarried(mouseStack);
                TrashHelper.setTrashItem((Player)player, message.isRightClick ? trashStack : ItemStack.EMPTY);
            } else {
                ItemStack trashStack = message.isRightClick ? actualMouseItem.split(1) : actualMouseItem;
                TrashHelper.setTrashItem((Player)player, trashStack);
                player.containerMenu.setCarried(message.isRightClick ? actualMouseItem : ItemStack.EMPTY);
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

