/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.transfer_labels.item;

import com.buuz135.transfer_labels.TransferLabels;
import com.buuz135.transfer_labels.filter.ILabelFilter;
import com.buuz135.transfer_labels.packet.LabelSyncPacket;
import com.buuz135.transfer_labels.storage.LabelStorage;
import com.hrznstudio.titanium.network.Message;
import java.util.Locale;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public abstract class TransferLabelItem
extends Item {
    private final Mode mode;
    private ResourceLocation texture;

    public TransferLabelItem(String type, Item.Properties properties, Mode mode) {
        super(properties);
        this.mode = mode;
        this.texture = ResourceLocation.fromNamespaceAndPath((String)"transfer_labels", (String)("textures/item/" + type + "_" + this.mode.name().toLowerCase(Locale.ROOT) + "_transfer_label.png"));
        TransferLabels.TAB.getTabList().add(this);
    }

    public Mode getMode() {
        return this.mode;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LabelStorage.addLabel(serverLevel, context.getClickedPos(), context.getClickedFace(), context.getItemInHand().copyWithCount(1));
            context.getItemInHand().shrink(1);
            TransferLabels.NETWORK.sendTo((Message)new LabelSyncPacket(serverLevel.getLevel().dimension().location(), LabelStorage.getStorageFor(serverLevel).save(new CompoundTag(), (HolderLookup.Provider)serverLevel.registryAccess())), (ServerPlayer)context.getPlayer());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public abstract ILabelFilter<?> createFilter();

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public static enum Mode {
        INSERT,
        EXTRACT;

    }
}

