/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.transfer_labels.gui.filter;

import com.buuz135.transfer_labels.filter.FilterType;
import com.buuz135.transfer_labels.filter.ItemFilter;
import com.buuz135.transfer_labels.filter.extras.NumberFilterExtra;
import com.buuz135.transfer_labels.filter.extras.TagFilterExtra;
import com.buuz135.transfer_labels.gui.ScrollableSelectionHelper;
import com.buuz135.transfer_labels.util.NumberUtils;
import com.hrznstudio.titanium.Titanium;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.api.filter.FilterSlot;
import com.hrznstudio.titanium.client.screen.addon.BasicScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.network.Message;
import com.hrznstudio.titanium.network.locator.ILocatable;
import com.hrznstudio.titanium.network.messages.ButtonClickNetworkMessage;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;

public class ItemFilterScreenAddon
extends BasicScreenAddon {
    private final ItemFilter filter;

    public ItemFilterScreenAddon(ItemFilter filter) {
        super(filter.getFilterSlots()[0].getX(), filter.getFilterSlots()[0].getY());
        this.filter = filter;
    }

    public int getXSize() {
        return this.filter.getFilterSlots()[this.filter.getFilterSlots().length - 1].getX() + 17;
    }

    public int getYSize() {
        return this.filter.getFilterSlots()[this.filter.getFilterSlots().length - 1].getY() + 17;
    }

    public void drawBackgroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        int i = 0;
        for (FilterSlot<ItemStack> filterSlot : this.filter.getFilterSlots()) {
            if (filterSlot == null) continue;
            AssetUtil.drawAsset((GuiGraphics)guiGraphics, (Screen)screen, (IAsset)Objects.requireNonNull(provider.getAsset(AssetTypes.SLOT)), (int)(guiX + filterSlot.getX()), (int)(guiY + filterSlot.getY()));
            Color color = switch (this.filter.getFilterType().getName()) {
                case "normal" -> new Color(DyeColor.BLUE.getFireworkColor());
                case "regulating" -> new Color(DyeColor.GREEN.getFireworkColor());
                case "exact_count" -> new Color(DyeColor.RED.getFireworkColor());
                case "mod" -> new Color(DyeColor.PURPLE.getFireworkColor());
                case "tag" -> new Color(DyeColor.YELLOW.getFireworkColor());
                default -> new Color(DyeColor.BLUE.getFireworkColor());
            };
            guiGraphics.fill(guiX + filterSlot.getX() + 1, guiY + filterSlot.getY() + 1, guiX + filterSlot.getX() + 17, guiY + filterSlot.getY() + 17, new Color(color.getRed(), color.getGreen(), color.getBlue(), 128).getRGB());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (!((ItemStack)filterSlot.getFilter()).isEmpty()) {
                Object extra;
                Lighting.setupFor3DItems();
                guiGraphics.renderItem((ItemStack)filterSlot.getFilter(), filterSlot.getX() + guiX + 1, filterSlot.getY() + guiY + 1);
                if (this.filter.getFilterType() == FilterType.EXACT_COUNT || this.filter.getFilterType() == FilterType.REGULATING) {
                    extra = (NumberFilterExtra)this.filter.getSavedFilters().get(this.filter.getFilterType().getName());
                    guiGraphics.pose().pushPose();
                    String amount = NumberUtils.getFormatedBigNumber(((NumberFilterExtra)extra).getExtra().get(i).intValue());
                    guiGraphics.pose().translate((double)(guiX + filterSlot.getX() + 17) - (double)Minecraft.getInstance().font.width(amount) / 2.0, (double)(guiY + filterSlot.getY() + 13), 200.0);
                    guiGraphics.pose().scale(0.5f, 0.5f, 0.5f);
                    guiGraphics.drawString(Minecraft.getInstance().font, amount, 0, 0, 0xFFFFFF);
                    guiGraphics.pose().popPose();
                }
                if (this.filter.getFilterType() == FilterType.TAG) {
                    extra = (TagFilterExtra)this.filter.getSavedFilters().get(this.filter.getFilterType().getName());
                    guiGraphics.pose().pushPose();
                    guiGraphics.enableScissor(guiX + filterSlot.getX() + 2, guiY + filterSlot.getY(), guiX + filterSlot.getX() + 16, guiY + filterSlot.getY() + 17);
                    List<String> stackTags = ((ItemStack)filterSlot.getFilter()).getTags().map(TagKey::location).map(ResourceLocation::toString).toList();
                    String text = ((TagFilterExtra)extra).getExtra().get(i) != null ? ((TagFilterExtra)extra).getExtra().get(i).location().toString() : (stackTags.isEmpty() ? "" : stackTags.get(0));
                    guiGraphics.pose().translate((double)(guiX + filterSlot.getX() + 1), (double)(guiY + filterSlot.getY() + 6), 200.0);
                    guiGraphics.pose().scale(0.5f, 0.5f, 0.5f);
                    ItemFilterScreenAddon.renderScrollingString(guiGraphics, Minecraft.getInstance().font, (Component)Component.literal((String)text), 2, 0, 30, 32, 0xFFFFFF);
                    guiGraphics.disableScissor();
                    guiGraphics.pose().popPose();
                }
            }
            ++i;
        }
    }

    public void drawForegroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        int i = 0;
        for (FilterSlot<ItemStack> filterSlot : this.filter.getFilterSlots()) {
            if (filterSlot != null && mouseX > guiX + filterSlot.getX() + 1 && mouseX < guiX + filterSlot.getX() + 16 && mouseY > guiY + filterSlot.getY() + 1 && mouseY < guiY + filterSlot.getY() + 16) {
                guiGraphics.pose().translate(0.0, 0.0, 200.0);
                guiGraphics.fill(filterSlot.getX() + 1, filterSlot.getY() + 1, filterSlot.getX() + 17, filterSlot.getY() + 17, -2130706433);
                if (!((ItemStack)filterSlot.getFilter()).isEmpty() && Minecraft.getInstance().player.containerMenu.getCarried().isEmpty()) {
                    Object extra;
                    List tooltip = Screen.getTooltipFromItem((Minecraft)screen.getMinecraft(), (ItemStack)((ItemStack)filterSlot.getFilter()));
                    if (this.filter.getFilterType() == FilterType.EXACT_COUNT || this.filter.getFilterType() == FilterType.REGULATING) {
                        extra = (NumberFilterExtra)this.filter.getSavedFilters().get(this.filter.getFilterType().getName());
                        tooltip.add(Component.literal((String)("Amount: " + String.valueOf(extra.getExtra().get(i)))).withStyle(ChatFormatting.GRAY));
                    }
                    if (this.filter.getFilterType() == FilterType.TAG) {
                        extra = (TagFilterExtra)this.filter.getSavedFilters().get(this.filter.getFilterType().getName());
                        List<String> stackTags = ((ItemStack)filterSlot.getFilter()).getTags().map(TagKey::location).map(ResourceLocation::toString).toList();
                        int finalI = i;
                        ScrollableSelectionHelper selectionHelper = new ScrollableSelectionHelper("", 0, stackTags, () -> ItemFilterScreenAddon.lambda$drawForegroundLayer$0((TagFilterExtra)extra, finalI, stackTags), true);
                        tooltip.add(Component.literal((String)"Selected Tag: ").withStyle(ChatFormatting.GRAY));
                        if (!stackTags.isEmpty()) {
                            tooltip.addAll(selectionHelper.getFormattedOptions().stream().map(s -> Component.literal((String)(" " + s))).toList());
                        } else {
                            tooltip.add(Component.literal((String)" None").withStyle(ChatFormatting.GRAY));
                        }
                        tooltip.add(Component.translatable((String)"filter.type.scroll").withStyle(ChatFormatting.DARK_GRAY));
                    }
                    guiGraphics.renderComponentTooltip(screen.getMinecraft().font, tooltip, mouseX - guiX, mouseY - guiY);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                guiGraphics.pose().translate(0.0, 0.0, -200.0);
            }
            ++i;
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof AbstractContainerScreen && ((AbstractContainerScreen)screen).getMenu() instanceof ILocatable) {
            if (!this.isMouseOver(mouseX - (double)((AbstractContainerScreen)screen).getGuiLeft(), mouseY - (double)((AbstractContainerScreen)screen).getGuiTop())) {
                return false;
            }
            ILocatable locatable = (ILocatable)((AbstractContainerScreen)screen).getMenu();
            for (FilterSlot<ItemStack> filterSlot : this.filter.getFilterSlots()) {
                if (filterSlot == null || !(mouseX > (double)(((AbstractContainerScreen)screen).getGuiLeft() + filterSlot.getX() + 1)) || !(mouseX < (double)(((AbstractContainerScreen)screen).getGuiLeft() + filterSlot.getX() + 16)) || !(mouseY > (double)(((AbstractContainerScreen)screen).getGuiTop() + filterSlot.getY() + 1)) || !(mouseY < (double)(((AbstractContainerScreen)screen).getGuiTop() + filterSlot.getY() + 16))) continue;
                CompoundTag compoundNBT = new CompoundTag();
                compoundNBT.putString("Name", this.filter.getName());
                compoundNBT.putInt("Slot", filterSlot.getFilterID());
                compoundNBT.put("Filter", Minecraft.getInstance().player.containerMenu.getCarried().saveOptional((HolderLookup.Provider)screen.getMinecraft().level.registryAccess()));
                Titanium.NETWORK.sendToServer((Message)new ButtonClickNetworkMessage(locatable.getLocatorInstance(), -2, compoundNBT));
                return true;
            }
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof AbstractContainerScreen && ((AbstractContainerScreen)screen).getMenu() instanceof ILocatable) {
            ILocatable locatable = (ILocatable)((AbstractContainerScreen)screen).getMenu();
            int i = 0;
            for (FilterSlot<ItemStack> filterSlot : this.filter.getFilterSlots()) {
                if (filterSlot != null && mouseX > (double)(filterSlot.getX() + 1) && mouseX < (double)(filterSlot.getX() + 16) && mouseY > (double)(filterSlot.getY() + 1) && mouseY < (double)(filterSlot.getY() + 16)) {
                    if (this.filter.getFilterType() == FilterType.EXACT_COUNT || this.filter.getFilterType() == FilterType.REGULATING) {
                        CompoundTag compoundNBT = new CompoundTag();
                        compoundNBT.putInt("FilterAmount", i);
                        compoundNBT.putDouble("Scroll", scrollY * (double)(Screen.hasShiftDown() ? 8 : 1) * (double)(Screen.hasControlDown() ? 8 : 1) * (double)(Screen.hasAltDown() ? 16 : 1));
                        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.TRIPWIRE_CLICK_ON, (float)2.0f));
                        Titanium.NETWORK.sendToServer((Message)new ButtonClickNetworkMessage(locatable.getLocatorInstance(), -7, compoundNBT));
                        return true;
                    }
                    if (this.filter.getFilterType() == FilterType.TAG) {
                        CompoundTag compoundNBT = new CompoundTag();
                        compoundNBT.putInt("FilterTag", i);
                        compoundNBT.putDouble("Scroll", scrollY);
                        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.TRIPWIRE_CLICK_ON, (float)2.0f));
                        Titanium.NETWORK.sendToServer((Message)new ButtonClickNetworkMessage(locatable.getLocatorInstance(), -7, compoundNBT));
                        return true;
                    }
                }
                ++i;
            }
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public static void renderScrollingString(GuiGraphics guiGraphics, Font font, Component text, int minX, int minY, int maxX, int maxY, int color) {
        ItemFilterScreenAddon.renderScrollingString(guiGraphics, font, text, (minX + maxX) / 2, minX, minY, maxX, maxY, color);
    }

    public static void renderScrollingString(GuiGraphics guiGraphics, Font font, Component text, int centerX, int minX, int minY, int maxX, int maxY, int color) {
        int i = font.width((FormattedText)text);
        int j = (minY + maxY - 9) / 2 + 1;
        int k = maxX - minX;
        if (i > k) {
            int l = i - k;
            double d0 = (double)Util.getMillis() / 1000.0;
            double d1 = Math.max((double)l * 0.5, 3.0);
            double d2 = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d0 / d1)) / 2.0 + 0.5;
            double d3 = Mth.lerp((double)d2, (double)0.0, (double)l);
            guiGraphics.drawString(font, text, minX - (int)d3, j, color);
        } else {
            int i1 = Mth.clamp((int)centerX, (int)(minX + i / 2), (int)(maxX - i / 2));
            guiGraphics.drawCenteredString(font, text, i1, j, color);
        }
    }

    private static /* synthetic */ String lambda$drawForegroundLayer$0(TagFilterExtra extra, int finalI, List stackTags) {
        return extra.getExtra().get(finalI) != null ? extra.getExtra().get(finalI).location().toString() : (stackTags.isEmpty() ? "null" : (String)stackTags.get(0));
    }
}

