/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.transfer_labels.gui;

import com.buuz135.transfer_labels.gui.ScrollableSelectionHelper;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.api.client.IAssetType;
import com.hrznstudio.titanium.client.screen.addon.BasicScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.network.locator.ILocatable;
import com.hrznstudio.titanium.util.AssetUtil;
import java.awt.Rectangle;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class ScrollableScreenAddon
extends BasicScreenAddon {
    private ScrollableSelectionHelper selectionHelper;
    private Supplier<IAssetType> assetType;
    private Rectangle area;

    public ScrollableScreenAddon(int posX, int posY, ScrollableSelectionHelper selectionHelper, Supplier<IAssetType> assetType) {
        super(posX, posY);
        this.selectionHelper = selectionHelper;
        this.assetType = assetType;
    }

    public int getXSize() {
        return this.area != null ? this.area.width : 0;
    }

    public int getYSize() {
        return this.area != null ? this.area.height : 0;
    }

    public void drawBackgroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider iAssetProvider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        if (this.assetType != null) {
            IAsset asset = iAssetProvider.getAsset(this.assetType.get());
            this.area = asset.getArea();
            AssetUtil.drawAsset((GuiGraphics)guiGraphics, (Screen)screen, (IAsset)asset, (int)(this.getPosX() + guiX), (int)(this.getPosY() + guiY));
        }
    }

    public void drawForegroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider iAssetProvider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        if (this.isMouseOver(mouseX - guiX, mouseY - guiY)) {
            AssetUtil.drawSelectingOverlay((GuiGraphics)guiGraphics, (int)(this.getPosX() + 2), (int)(this.getPosY() + 2), (int)(this.getPosX() + this.getXSize() - 2), (int)(this.getPosY() + this.getYSize() - 3));
        }
    }

    public void setAssetType(Supplier<IAssetType> assetType) {
        this.assetType = assetType;
    }

    public List<Component> getTooltipLines() {
        return this.selectionHelper.getFormattedOptions().stream().map(s -> Component.literal((String)s)).collect(Collectors.toList());
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        ILocatable locatable;
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof AbstractContainerScreen && ((AbstractContainerScreen)screen).getMenu() instanceof ILocatable && this.selectionHelper.mouseScrolled(mouseX, mouseY, scrollX, scrollY, locatable = (ILocatable)((AbstractContainerScreen)screen).getMenu())) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.TRIPWIRE_CLICK_ON, (float)2.0f));
            return true;
        }
        return false;
    }
}

