/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.transfer_labels.filter;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public final class FilterType {
    public static final List<FilterType> FILTERS = new ArrayList<FilterType>();
    public static final FilterType NORMAL = new FilterType("normal", "filter.type.normal", "filter.type.normal.tooltip");
    public static final FilterType REGULATING = new FilterType("regulating", "filter.type.regulating", "filter.type.regulating.tooltip");
    public static final FilterType EXACT_COUNT = new FilterType("exact_count", "filter.type.exact_count", "filter.type.exact_count.tooltip");
    public static final FilterType MOD = new FilterType("mod", "filter.type.mod", "filter.type.mod.tooltip");
    public static final FilterType TAG = new FilterType("tag", "filter.type.tag", "filter.type.tag.tooltip");
    private final String name;
    private final String displayName;
    private final String extraTooltip;

    public static FilterType getByName(String name) {
        for (FilterType filterType : FILTERS) {
            if (!filterType.getName().equalsIgnoreCase(name)) continue;
            return filterType;
        }
        return NORMAL;
    }

    public static FilterType getNext(String currentName) {
        FilterType current = FilterType.getByName(currentName);
        int currentIndex = FILTERS.indexOf(current);
        int nextIndex = (currentIndex + 1) % FILTERS.size();
        return FILTERS.get(nextIndex);
    }

    public static FilterType getPrevious(String currentName) {
        FilterType current = FilterType.getByName(currentName);
        int currentIndex = FILTERS.indexOf(current);
        int previousIndex = (currentIndex - 1 + FILTERS.size()) % FILTERS.size();
        return FILTERS.get(previousIndex);
    }

    public FilterType(String name, String displayName, String extraTooltip) {
        this.name = name;
        this.displayName = displayName;
        this.extraTooltip = extraTooltip;
        FILTERS.add(this);
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getExtraTooltip() {
        return this.extraTooltip;
    }

    public List<String> getTooltip() {
        return List.of(String.valueOf(ChatFormatting.YELLOW) + Component.translatable((String)this.displayName).getString(), "   " + String.valueOf(ChatFormatting.GRAY) + Component.translatable((String)this.extraTooltip).getString());
    }
}

