/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.transfer_labels;

import com.buuz135.transfer_labels.TransferLabels;
import com.buuz135.transfer_labels.client.RayTraceUtils;
import com.buuz135.transfer_labels.item.TransferLabelItem;
import com.buuz135.transfer_labels.packet.LabelSyncPacket;
import com.buuz135.transfer_labels.storage.LabelBlock;
import com.buuz135.transfer_labels.storage.LabelLocatorInstance;
import com.buuz135.transfer_labels.storage.LabelStorage;
import com.hrznstudio.titanium.network.Message;
import com.hrznstudio.titanium.network.locator.LocatorFactory;
import com.hrznstudio.titanium.network.locator.LocatorInstance;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

public class LabelInteractEvents {
    public static List<DelayedEvent> SERVER_UPDATE = new ArrayList<DelayedEvent>();

    @SubscribeEvent
    public void onTick(LevelTickEvent.Pre event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LabelStorage.getStorageFor(serverLevel).getLabelBlocks().forEach(labelBlock -> labelBlock.getLabels().forEach((direction, label) -> label.work((Level)serverLevel)));
            if (event.getLevel().getGameTime() % 20L == 0L) {
                serverLevel.players().forEach(player -> TransferLabels.NETWORK.sendTo((Message)new LabelSyncPacket(serverLevel.getLevel().dimension().location(), LabelStorage.getStorageFor(serverLevel).save(new CompoundTag(), (HolderLookup.Provider)serverLevel.registryAccess())), player));
            }
        }
    }

    @SubscribeEvent
    public void onTick(LevelTickEvent.Post event) {
        int delay = 2;
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SERVER_UPDATE.forEach(leftClickBlock -> {
                if (serverLevel.getGameTime() > leftClickBlock.time + (long)delay && leftClickBlock.event.getLevel().equals(event.getLevel())) {
                    leftClickBlock.event.getLevel().destroyBlockProgress(leftClickBlock.event.getEntity().getId(), leftClickBlock.event.getPos(), -1);
                }
            });
            SERVER_UPDATE.removeIf(leftClickBlock -> serverLevel.getGameTime() > leftClickBlock.time + (long)delay && leftClickBlock.event.getLevel().equals(event.getLevel()));
        }
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        boolean isHoldingAccessor = event.getItemStack().is((Item)TransferLabels.LABEL_ACCESSOR.get());
        boolean validInteraction = event.getItemStack().getItem() instanceof TransferLabelItem || isHoldingAccessor;
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            List<LabelBlock> nearbyLabels;
            Pair<LabelBlock, Direction> pair;
            ServerLevel serverLevel = (ServerLevel)level;
            if (validInteraction && (pair = RayTraceUtils.rayTraceVoxelShape(nearbyLabels = LabelStorage.getNearbyLabels(serverLevel, event.getPos(), 20), (Level)serverLevel, (LivingEntity)event.getEntity(), 0.0f, isHoldingAccessor ? null : event.getPos())) != null) {
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
                Player player = event.getEntity();
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.openMenu((MenuProvider)((LabelBlock)pair.getFirst()).getLabels().get(pair.getSecond()), buffer -> LocatorFactory.writePacketBuffer((RegistryFriendlyByteBuf)buffer, (LocatorInstance)new LabelLocatorInstance(((LabelBlock)pair.getFirst()).getPos(), (Direction)pair.getSecond())));
                }
            }
        }
    }

    @SubscribeEvent
    public void onLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        Level level;
        boolean validInteraction;
        boolean isHoldingAccessor = event.getItemStack().is((Item)TransferLabels.LABEL_ACCESSOR.get());
        boolean bl = validInteraction = event.getItemStack().getItem() instanceof TransferLabelItem || isHoldingAccessor;
        if (validInteraction && event.getAction() == PlayerInteractEvent.LeftClickBlock.Action.START && (level = event.getLevel()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double distance = event.getEntity().getAttribute(Attributes.BLOCK_INTERACTION_RANGE).getValue();
            List<LabelBlock> nearbyLabels = LabelStorage.getNearbyLabels(serverLevel, event.getPos(), (int)(distance * distance));
            Pair<LabelBlock, Direction> pair = RayTraceUtils.rayTraceVoxelShape(nearbyLabels, (Level)serverLevel, (LivingEntity)event.getEntity(), 0.0f, isHoldingAccessor ? null : event.getPos());
            if (pair != null) {
                event.setCanceled(true);
                LabelStorage.removeLabel(event.getEntity(), serverLevel, ((LabelBlock)pair.getFirst()).getPos(), (Direction)pair.getSecond());
                TransferLabels.NETWORK.sendTo((Message)new LabelSyncPacket(serverLevel.getLevel().dimension().location(), LabelStorage.getStorageFor(serverLevel).save(new CompoundTag(), (HolderLookup.Provider)serverLevel.registryAccess())), (ServerPlayer)event.getEntity());
                event.getEntity().playNotifySound(SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
                SERVER_UPDATE.add(new DelayedEvent(event, serverLevel.getGameTime()));
            }
        }
    }

    public record DelayedEvent(PlayerInteractEvent.LeftClickBlock event, long time) {
    }
}

