/*
 * Decompiled with CFR 0.152.
 */
package com.cake.trading_floor.foundation.advancement;

import com.cake.trading_floor.TradingFloor;
import com.cake.trading_floor.foundation.advancement.TFAdvancement;
import com.cake.trading_floor.registry.TFRegistry;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class TFAdvancements
implements DataProvider {
    public static final List<TFAdvancement> ENTRIES = new ArrayList<TFAdvancement>();
    public static final TFAdvancement MONEY_MONEY_MONEY = TFAdvancements.createTF("money_money_money", b -> b.icon((ItemProviderEntry<?, ?>)TFRegistry.TRADING_DEPOT).title("Money Money Money,").description("Make a trade automatically using a trading depot").afterCreateRoot());
    public static final TFAdvancement BUDDING_CAPITALIST = TFAdvancements.createTF("drop_shipper", b -> b.icon((ItemLike)Items.EMERALD).title("Intro to drop-shipping").description("Generate 64 emeralds from a single trading depot").after(MONEY_MONEY_MONEY).special(TFAdvancement.TaskType.NOISY));
    public static final TFAdvancement HAPPY_JEFF = TFAdvancements.createTF("happy_jeff", b -> b.icon((ItemLike)Items.EMERALD_BLOCK).title("Jeff Bezos would be proud").description("Generate 1000 emeralds from a single trading depot").after(BUDDING_CAPITALIST).special(TFAdvancement.TaskType.NOISY));
    private final PackOutput output;
    private final CompletableFuture<HolderLookup.Provider> registries;

    protected static TFAdvancement createTF(String id, UnaryOperator<TFAdvancement.Builder> b) {
        return new TFAdvancement(id, b);
    }

    public TFAdvancements(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        this.output = output;
        this.registries = registries;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        return this.registries.thenCompose(provider -> {
            PackOutput.PathProvider pathProvider = this.output.createPathProvider(PackOutput.Target.DATA_PACK, "advancement");
            ArrayList futures = new ArrayList();
            HashSet set = Sets.newHashSet();
            Consumer<AdvancementHolder> consumer = advancement -> {
                ResourceLocation id = advancement.id();
                if (!set.add(id)) {
                    throw new IllegalStateException("Duplicate advancement " + String.valueOf(id));
                }
                Path path = pathProvider.json(id);
                LOGGER.info("Saving advancement {}", (Object)id);
                futures.add(DataProvider.saveStable((CachedOutput)cache, (HolderLookup.Provider)provider, (Codec)Advancement.CODEC, (Object)advancement.value(), (Path)path));
            };
            for (TFAdvancement advancement2 : ENTRIES) {
                advancement2.save(consumer, (HolderLookup.Provider)provider);
            }
            return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
        });
    }

    public String getName() {
        return "Trading Floor's Advancements";
    }

    public static void provideLang(BiConsumer<String, String> consumer) {
        for (TFAdvancement advancement : ENTRIES) {
            advancement.provideLang(consumer);
        }
    }

    public static void register() {
        TradingFloor.LOGGER.info("Registering Advancements for: Create: Trading Floor");
    }
}

