/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.village.VillageSiege;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Level;
import net.xalcon.torchmaster.Torchmaster;
import net.xalcon.torchmaster.logic.entityblocking.TorchInfo;

public class CommandTorchmaster {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder command = Commands.literal((String)"torchmaster");
        for (SubCommands subCommand : SubCommands.values()) {
            command.then(Commands.literal((String)subCommand.getTranslationKey()).executes(subCommand::execute));
        }
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)command.requires(cmdSrc -> cmdSrc.hasPermission(2))).executes(ctx -> 0));
    }

    public static enum SubCommands {
        DUMP_TORCHES("torchdump"){

            @Override
            public int execute(CommandContext<CommandSourceStack> ctx) {
                CommandSourceStack source = (CommandSourceStack)ctx.getSource();
                MinecraftServer server = source.getServer();
                Torchmaster.LOG.info("#################################");
                Torchmaster.LOG.info("# Torchmaster Torch Dump Start  #");
                Torchmaster.LOG.info("#################################");
                for (ServerLevel level : server.getAllLevels()) {
                    Torchmaster.getRegistryForLevel((Level)level).ifPresent(container -> {
                        Torchmaster.LOG.info("Torches in dimension {}:", (Object)level.dimension().registry());
                        for (TorchInfo torch : container.getEntries()) {
                            Torchmaster.LOG.info("  {} @ {}", (Object)torch.getName(), (Object)torch.getPos());
                        }
                    });
                }
                Torchmaster.LOG.info("#################################");
                Torchmaster.LOG.info("# Torchmaster Torch Dump End    #");
                Torchmaster.LOG.info("#################################");
                source.sendSuccess(() -> Component.translatable((String)"torchmaster.command.torch_dump.completed"), false);
                return 0;
            }
        }
        ,
        DUMP_ENTITIES("entitydump"){

            @Override
            public int execute(CommandContext<CommandSourceStack> ctx) {
                CommandSourceStack source = (CommandSourceStack)ctx.getSource();
                Torchmaster.LOG.info("#################################");
                Torchmaster.LOG.info("# Torchmaster Entity Dump Start #");
                Torchmaster.LOG.info("#################################");
                Torchmaster.LOG.info("List of registered entities:");
                BuiltInRegistries.ENTITY_TYPE.stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ENTITY_TYPE).getKey(arg_0)).forEach(loc -> Torchmaster.LOG.info("  {}", loc));
                Torchmaster.LOG.info("Dread Lamp Registry Content:");
                for (ResourceLocation loc2 : Torchmaster.DreadLampFilterRegistry.getEntities()) {
                    Torchmaster.LOG.info("  {}", (Object)loc2);
                }
                Torchmaster.LOG.info("Mega Torch Registry Content:");
                for (ResourceLocation loc2 : Torchmaster.MegaTorchFilterRegistry.getEntities()) {
                    Torchmaster.LOG.info("  {}", (Object)loc2);
                }
                Torchmaster.LOG.info("#################################");
                Torchmaster.LOG.info("# Torchmaster Entity Dump End   #");
                Torchmaster.LOG.info("#################################");
                source.sendSuccess(() -> Component.translatable((String)"torchmaster.command.entity_dump.completed"), false);
                return 0;
            }
        }
        ,
        TRY_SETUP_SIEGE("try_setup_siege"){

            @Override
            public int execute(CommandContext<CommandSourceStack> ctx) {
                ServerLevel level = ((CommandSourceStack)ctx.getSource()).getLevel();
                try {
                    Field field = ServerLevel.class.getDeclaredField("customSpawners");
                    field.setAccessible(true);
                    List customSpawnersList = (List)field.get(level);
                    for (CustomSpawner customSpawner : customSpawnersList) {
                        if (!(customSpawner instanceof VillageSiege)) continue;
                        VillageSiege siege = (VillageSiege)customSpawner;
                        Field siegeStateField = VillageSiege.class.getDeclaredField("siegeState");
                        siegeStateField.setAccessible(true);
                        siegeStateField.set(siege, siegeStateField.getType().getEnumConstants()[1]);
                        Field hasSetupSiegeField = VillageSiege.class.getDeclaredField("hasSetupSiege");
                        hasSetupSiegeField.setAccessible(true);
                        hasSetupSiegeField.setBoolean(siege, false);
                        ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"Attempting village siege"));
                    }
                }
                catch (Exception ex) {
                    ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"Exception during siege setup"));
                    Torchmaster.LOG.error("Error while setting up siege", (Throwable)ex);
                }
                return 0;
            }
        };

        private final String translationKey;

        private SubCommands(String translationKey) {
            this.translationKey = translationKey;
        }

        public abstract int execute(CommandContext<CommandSourceStack> var1);

        public String getTranslationKey() {
            return this.translationKey;
        }
    }
}

