/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.rei;

import com.tom.storagemod.Content;
import com.tom.storagemod.rei.ReiGhostIngredientHandler;
import com.tom.storagemod.rei.ReiTransferHandler;
import com.tom.storagemod.screen.AbstractStorageTerminalScreen;
import com.tom.storagemod.util.IAutoFillTerminal;
import dev.architectury.event.CompoundEventResult;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitor;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.ItemLike;

public class REIPlugin
implements REIClientPlugin {
    public void registerTransferHandlers(TransferHandlerRegistry recipeHelper) {
        recipeHelper.register((TransferHandler)new ReiTransferHandler());
    }

    public static void setReiSearchText(String text) {
        REIRuntime.getInstance().getSearchTextField().setText(text);
    }

    public void registerCategories(CategoryRegistry registry) {
        registry.addWorkstations(BuiltinPlugin.CRAFTING, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)Content.craftingTerminal.get()))});
    }

    public void registerScreens(ScreenRegistry registry) {
        registry.registerFocusedStack((scr, point) -> {
            AbstractStorageTerminalScreen t;
            Slot sl;
            if (scr instanceof AbstractStorageTerminalScreen && (sl = (t = (AbstractStorageTerminalScreen)scr).getSlotUnderMouse()) != null) {
                return CompoundEventResult.interruptTrue((Object)EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)sl.getItem()));
            }
            return CompoundEventResult.pass();
        });
        registry.registerDraggableStackVisitor((DraggableStackVisitor)new ReiGhostIngredientHandler());
    }

    static {
        IAutoFillTerminal.updateSearch.add(new IAutoFillTerminal.ISearchHandler(){

            @Override
            public void setSearch(String text) {
                REIRuntime.getInstance().getSearchTextField().setText(text);
            }

            @Override
            public String getSearch() {
                return REIRuntime.getInstance().getSearchTextField().getText();
            }

            @Override
            public String getName() {
                return "REI";
            }
        });
    }
}

