/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.menu;

import com.tom.storagemod.block.entity.CraftingTerminalBlockEntity;
import com.tom.storagemod.inventory.StoredItemStack;
import com.tom.storagemod.util.TerminalSyncManager;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class TerminalCraftingFiller {
    private CraftingTerminalBlockEntity te;
    private Player player;
    private Int2ObjectMap<List<ItemStack>> allItems = new Int2ObjectOpenHashMap();
    private TerminalSyncManager sync;

    public TerminalCraftingFiller(CraftingTerminalBlockEntity te, Player player, TerminalSyncManager sync) {
        this.te = te;
        this.player = player;
        this.sync = sync;
    }

    public void placeRecipe(Recipe<?> recipe) {
        int rw;
        this.te.clear(this.player);
        this.sync.fillCraftingFiller(this);
        for (ItemStack i : this.player.getInventory().items) {
            this.accountStack(i);
        }
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe sr = (ShapedRecipe)recipe;
            rw = sr.getWidth();
        } else {
            int cnt = recipe.getIngredients().size();
            rw = cnt == 1 ? 1 : (cnt <= 4 ? 2 : 3);
        }
        NonNullList ings = recipe.getIngredients();
        block1: for (int i = 0; i < ings.size(); ++i) {
            Ingredient ingr = (Ingredient)ings.get(i);
            if (ingr.isEmpty()) continue;
            int x = i % rw;
            int y = i / rw;
            boolean filled = false;
            IntListIterator intListIterator = ingr.getStackingIds().iterator();
            while (intListIterator.hasNext()) {
                int v = (Integer)intListIterator.next();
                List lst = (List)this.allItems.get(v);
                if (lst == null) continue;
                for (ItemStack item : lst) {
                    if (!ingr.test(item)) continue;
                    StoredItemStack pull = this.te.pullStack(new StoredItemStack(item), 1L);
                    if (pull != null) {
                        filled = true;
                        this.te.setCraftSlot(x, y, pull.getActualStack());
                        break;
                    }
                    int id = this.player.getInventory().findSlotMatchingItem(item);
                    if (id == -1) continue;
                    this.te.setCraftSlot(x, y, this.player.getInventory().removeItem(id, 1));
                    filled = true;
                    break;
                }
                if (!filled) continue;
                continue block1;
            }
        }
    }

    public void accountStack(ItemStack st) {
        if (st.has(DataComponents.CUSTOM_NAME)) {
            return;
        }
        int index = StackedContents.getStackingIndex((ItemStack)st);
        ((List)this.allItems.computeIfAbsent(index, __ -> new ArrayList())).add(st);
    }
}

