/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.jei;

import com.tom.storagemod.Content;
import com.tom.storagemod.jei.CraftingTerminalTransferHandler;
import com.tom.storagemod.jei.JeiGhostIngredientHandler;
import com.tom.storagemod.screen.AbstractFilteredScreen;
import com.tom.storagemod.screen.CraftingTerminalScreen;
import com.tom.storagemod.util.IAutoFillTerminal;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class JEIHandler
implements IModPlugin {
    private static IJeiRuntime jeiRuntime;

    public ResourceLocation getPluginUid() {
        return ResourceLocation.tryBuild((String)"toms_storage", (String)"jei");
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(CraftingTerminalScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<CraftingTerminalScreen>(this){
            private RecipeType[] rt = new RecipeType[]{RecipeTypes.CRAFTING};

            public Collection<IGuiClickableArea> getGuiClickableAreas(CraftingTerminalScreen containerScreen, double mouseX, double mouseY) {
                int rowCount = containerScreen.getRowCount();
                IGuiClickableArea clickableArea = IGuiClickableArea.createBasic((int)83, (int)(35 + rowCount * 18), (int)28, (int)23, (RecipeType[])this.rt);
                return List.of(clickableArea);
            }
        });
        registration.addGhostIngredientHandler(AbstractFilteredScreen.class, (IGhostIngredientHandler)new JeiGhostIngredientHandler());
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        CraftingTerminalTransferHandler.registerTransferHandlers(registration);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Content.craftingTerminal.get()), new RecipeType[]{RecipeTypes.CRAFTING});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        JEIHandler.jeiRuntime = jeiRuntime;
    }

    static {
        IAutoFillTerminal.updateSearch.add(new IAutoFillTerminal.ISearchHandler(){

            @Override
            public void setSearch(String text) {
                if (jeiRuntime != null && jeiRuntime.getIngredientFilter() != null) {
                    jeiRuntime.getIngredientFilter().setFilterText(text);
                }
            }

            @Override
            public String getSearch() {
                if (jeiRuntime != null && jeiRuntime.getIngredientFilter() != null) {
                    return jeiRuntime.getIngredientFilter().getFilterText();
                }
                return "";
            }

            @Override
            public String getName() {
                return "JEI";
            }
        });
    }
}

