/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tom.storagemod.Content;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;

public record ConfiguratorComponent(BlockPos bound, boolean isBound, boolean selecting, boolean showInvBox, boolean massSelect, BlockPos boxStart, List<BlockPos> selection) {
    private static final ConfiguratorComponent EMPTY = new ConfiguratorComponent(BlockPos.ZERO, false, false, false, false, BlockPos.ZERO, Collections.emptyList());
    public static final Codec<ConfiguratorComponent> CODEC = RecordCodecBuilder.mapCodec(b -> b.group((App)BlockPos.CODEC.fieldOf("bound").forGetter(ConfiguratorComponent::bound), (App)Codec.BOOL.fieldOf("is_bound").forGetter(ConfiguratorComponent::isBound), (App)Codec.BOOL.fieldOf("selecting").forGetter(ConfiguratorComponent::selecting), (App)Codec.BOOL.fieldOf("show_inv_box").forGetter(ConfiguratorComponent::showInvBox), (App)Codec.BOOL.fieldOf("mass_select").forGetter(ConfiguratorComponent::massSelect), (App)BlockPos.CODEC.fieldOf("box_start").forGetter(ConfiguratorComponent::boxStart), (App)Codec.list((Codec)BlockPos.CODEC).fieldOf("selection").forGetter(ConfiguratorComponent::selection)).apply((Applicative)b, ConfiguratorComponent::new)).codec();

    public static ConfiguratorComponent empty() {
        return EMPTY;
    }

    public ConfiguratorComponent hiddenItem() {
        return new ConfiguratorComponent(this.bound, this.isBound, this.selecting, false, false, this.boxStart, this.selection);
    }

    public ConfiguratorComponent showInv(List<BlockPos> sel) {
        return new ConfiguratorComponent(this.bound, this.isBound, this.selecting, true, this.massSelect, this.boxStart, sel);
    }

    public ConfiguratorComponent massSelectStart(BlockPos pos) {
        return new ConfiguratorComponent(this.bound, this.isBound, this.selecting, this.showInvBox, true, pos, this.selection);
    }

    public ConfiguratorComponent massSelectEnd() {
        return new ConfiguratorComponent(this.bound, this.isBound, this.selecting, this.showInvBox, false, BlockPos.ZERO, this.selection);
    }

    public ConfiguratorComponent massSelectEnd(List<BlockPos> sel) {
        return new ConfiguratorComponent(this.bound, this.isBound, this.selecting, this.showInvBox, false, BlockPos.ZERO, sel);
    }

    public ConfiguratorComponent setSelection(List<BlockPos> sel) {
        return new ConfiguratorComponent(this.bound, this.isBound, this.selecting, this.showInvBox, this.massSelect, this.boxStart, sel);
    }

    public static class Configurator {
        private ItemStack stack;
        private ConfiguratorComponent comp;

        public Configurator(ItemStack stack) {
            this.stack = stack;
            this.comp = (ConfiguratorComponent)stack.get(Content.configuratorComponent.get());
        }

        public BlockPos bound() {
            return this.comp.bound();
        }

        public BlockPos boxStart() {
            return this.comp.boxStart();
        }

        public boolean isBound() {
            return this.comp.isBound();
        }

        public boolean massSelect() {
            return this.comp.massSelect();
        }

        public boolean selecting() {
            return this.comp.selecting();
        }

        public List<BlockPos> selection() {
            return this.comp.selection();
        }

        public boolean showInvBox() {
            return this.comp.showInvBox();
        }

        public void massSelectStart(BlockPos pos) {
            this.set(this.comp.massSelectStart(pos));
        }

        public void massSelectEnd() {
            this.set(this.comp.massSelectEnd());
        }

        public void clear() {
            this.set(EMPTY);
        }

        public void showInvBox(Collection<BlockPos> sel) {
            this.set(this.comp.showInv(new ArrayList<BlockPos>(sel)));
        }

        public void massSelectEnd(Collection<BlockPos> sel) {
            this.set(this.comp.massSelectEnd(new ArrayList<BlockPos>(sel)));
        }

        public void setSelection(Collection<BlockPos> sel) {
            this.set(this.comp.setSelection(new ArrayList<BlockPos>(sel)));
        }

        public void startSelection(BlockPos bind, Collection<BlockPos> sel) {
            this.set(new ConfiguratorComponent(bind, true, true, false, false, BlockPos.ZERO, new ArrayList<BlockPos>(sel)));
        }

        private void set(ConfiguratorComponent c) {
            this.comp = c;
            this.stack.set(Content.configuratorComponent.get(), (Object)c);
        }
    }
}

