/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.block;

import com.mojang.serialization.MapCodec;
import com.tom.storagemod.block.IConfiguratorHighlight;
import com.tom.storagemod.block.IPaintable;
import com.tom.storagemod.block.entity.InventoryProxyBlockEntity;
import com.tom.storagemod.block.entity.PaintedBlockEntity;
import com.tom.storagemod.client.ClientUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class InventoryProxyBlock
extends BaseEntityBlock
implements IPaintable,
IConfiguratorHighlight {
    public static final MapCodec<InventoryProxyBlock> CODEC = ChestBlock.simpleCodec(properties -> new InventoryProxyBlock());
    public static final DirectionProperty FACING = BlockStateProperties.FACING;

    public InventoryProxyBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).sound(SoundType.WOOD).strength(3.0f));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.DOWN));
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.toms_storage.paintable"));
        ClientUtil.tooltip("inventory_proxy", tooltip, new Object[0]);
    }

    @Override
    public boolean paint(Level world, BlockPos pos, BlockState to) {
        BlockEntity te = world.getBlockEntity(pos);
        if (te != null && te instanceof PaintedBlockEntity) {
            return ((PaintedBlockEntity)te).setPaintedBlockState(to);
        }
        return false;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new InventoryProxyBlockEntity(pos, state);
    }

    public RenderShape getRenderShape(BlockState p_149645_1_) {
        return RenderShape.MODEL;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace().getOpposite());
    }

    @Override
    public int getHighlightColor() {
        return 0x880088;
    }

    @Override
    public VoxelShape getHighlightShape(BlockState state, BlockGetter level, BlockPos pos) {
        switch ((Direction)state.getValue((Property)FACING)) {
            case DOWN: {
                return Shapes.or((VoxelShape)InventoryProxyBlock.box((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0), (VoxelShape)InventoryProxyBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0));
            }
            case EAST: {
                return Shapes.or((VoxelShape)InventoryProxyBlock.box((double)4.0, (double)4.0, (double)4.0, (double)14.0, (double)12.0, (double)12.0), (VoxelShape)InventoryProxyBlock.box((double)14.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0));
            }
            case NORTH: {
                return Shapes.or((VoxelShape)InventoryProxyBlock.box((double)4.0, (double)4.0, (double)2.0, (double)12.0, (double)12.0, (double)12.0), (VoxelShape)InventoryProxyBlock.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)2.0));
            }
            case SOUTH: {
                return Shapes.or((VoxelShape)InventoryProxyBlock.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)14.0), (VoxelShape)InventoryProxyBlock.box((double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0, (double)16.0));
            }
            case UP: {
                return Shapes.or((VoxelShape)InventoryProxyBlock.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), (VoxelShape)InventoryProxyBlock.box((double)2.0, (double)14.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0));
            }
            case WEST: {
                return Shapes.or((VoxelShape)InventoryProxyBlock.box((double)2.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0), (VoxelShape)InventoryProxyBlock.box((double)0.0, (double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0));
            }
        }
        return Shapes.block();
    }
}

