/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod;

import com.tom.storagemod.StorageMod;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    private static final Config INSTANCE = new Config();
    public boolean onlyTrims;
    public boolean runMultithreaded;
    public int invConnectorScanRange;
    public int invConnectorCableRange = 0;
    public int wirelessRange;
    public int advWirelessRange;
    public int wirelessTermBeaconLvl;
    public int wirelessTermBeaconLvlCrossDim;
    public int invLinkBeaconLvl;
    public int invLinkBeaconRange;
    public int invLinkBeaconLvlSameDim;
    public int invLinkBeaconLvlCrossDim;
    private Set<String> blockedMods = new HashSet<String>();
    private Set<Block> blockedBlocks = new HashSet<Block>();
    static final ModConfigSpec commonSpec;
    public static final Common COMMON;
    static final ModConfigSpec serverSpec;
    public static final Server SERVER;

    public static Config get() {
        return INSTANCE;
    }

    private void load(ModConfig modConfig) {
        if (modConfig.getType() == ModConfig.Type.SERVER) {
            this.onlyTrims = (Boolean)Config.SERVER.onlyTrimsConnect.get();
            this.invConnectorScanRange = (Integer)Config.SERVER.invConnectorScanRange.get();
            this.invConnectorCableRange = (Integer)Config.SERVER.invConnectorCableRange.get();
            this.wirelessRange = (Integer)Config.SERVER.wirelessRange.get();
            this.advWirelessRange = (Integer)Config.SERVER.advWirelessRange.get();
            this.wirelessTermBeaconLvl = (Integer)Config.SERVER.wirelessTermBeaconLvl.get();
            this.wirelessTermBeaconLvlCrossDim = (Integer)Config.SERVER.wirelessTermBeaconLvlCrossDim.get();
            this.invLinkBeaconLvl = (Integer)Config.SERVER.invLinkBeaconLvl.get();
            this.invLinkBeaconRange = (Integer)Config.SERVER.invLinkBeaconRange.get();
            this.invLinkBeaconLvlSameDim = (Integer)Config.SERVER.invLinkBeaconLvlSameDim.get();
            this.invLinkBeaconLvlCrossDim = (Integer)Config.SERVER.invLinkBeaconLvlCrossDim.get();
            this.runMultithreaded = Config.SERVER.runMultithreaded.getAsBoolean();
        } else if (modConfig.getType() == ModConfig.Type.COMMON) {
            this.blockedMods = new HashSet<String>((Collection)Config.COMMON.blockedMods.get());
            this.blockedBlocks = ((List)Config.COMMON.blockedBlocks.get()).stream().map(ResourceLocation::tryParse).filter(e -> e != null).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).get(arg_0)).filter(e -> e != null && e != Blocks.AIR).collect(Collectors.toSet());
        }
    }

    @SubscribeEvent
    public void onLoad(ModConfigEvent.Loading configEvent) {
        StorageMod.LOGGER.info("Loaded Tom's Simple Storage config file {}", (Object)configEvent.getConfig().getFileName());
        this.load(configEvent.getConfig());
    }

    @SubscribeEvent
    public void onFileChange(ModConfigEvent.Reloading configEvent) {
        StorageMod.LOGGER.info("Tom's Simple Storage config just got changed on the file system!");
        this.load(configEvent.getConfig());
    }

    public Set<Block> getBlockedBlocks() {
        return this.blockedBlocks;
    }

    public Set<String> getBlockedMods() {
        return this.blockedMods;
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Common::new);
        commonSpec = (ModConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        specPair = new ModConfigSpec.Builder().configure(Server::new);
        serverSpec = (ModConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public ModConfigSpec.IntValue invConnectorScanRange;
        public ModConfigSpec.IntValue invConnectorCableRange;
        public ModConfigSpec.IntValue wirelessRange;
        public ModConfigSpec.BooleanValue onlyTrimsConnect;
        public ModConfigSpec.BooleanValue runMultithreaded;
        public ModConfigSpec.IntValue advWirelessRange;
        public ModConfigSpec.IntValue wirelessTermBeaconLvl;
        public ModConfigSpec.IntValue wirelessTermBeaconLvlCrossDim;
        public ModConfigSpec.IntValue invLinkBeaconLvl;
        public ModConfigSpec.IntValue invLinkBeaconRange;
        public ModConfigSpec.IntValue invLinkBeaconLvlSameDim;
        public ModConfigSpec.IntValue invLinkBeaconLvlCrossDim;

        private Server(ModConfigSpec.Builder builder) {
            this.invConnectorScanRange = builder.comment("Inventory Connector Range").translation("config.toms_storage.inventory_connector_range").defineInRange("inventoryConnectorRange", 16, 4, 256);
            this.onlyTrimsConnect = builder.comment("Only Allow Trims to Connect Inventories").translation("config.toms_storage.only_trims_connect").define("onlyTrimsConnect", false);
            this.invConnectorCableRange = builder.comment("Inventory Cable Connector Maximum number of cables").translation("config.toms_storage.inv_cable_connector_max_scan").defineInRange("invCableConnectorMaxScanSize", 2048, 16, Integer.MAX_VALUE);
            this.wirelessRange = builder.comment("Wireless terminal reach").translation("config.toms_storage.wireless_reach").defineInRange("wirelessReach", 16, 4, 64);
            this.advWirelessRange = builder.comment("Wireless terminal reach").translation("config.toms_storage.adv_wireless_range").defineInRange("advWirelessRange", 64, 16, 512);
            this.wirelessTermBeaconLvl = builder.comment(new String[]{"Adv Wireless terminal requied beacon level for infinite range", "Value of 0 only requires a single beacon block nearby", "Value of -1 disables this feature entirely"}).translation("config.toms_storage.adv_wireless_beacon_lvl").defineInRange("wirelessTermBeaconLvl", 1, -1, 4);
            this.wirelessTermBeaconLvlCrossDim = builder.comment(new String[]{"Adv Wireless terminal requied beacon level for cross dimensional access", "Value of 0 only requires a single beacon block nearby", "Value of -1 disables this feature entirely"}).translation("config.toms_storage.adv_wireless_beacon_lvl_dim").defineInRange("wirelessTermBeaconLvlDim", 4, -1, 4);
            this.invLinkBeaconLvl = builder.comment(new String[]{"Inventory Cable Connector requied beacon level for inventory linking", "Value of 0 only requires a single beacon block", "Value of -1 disables this feature entirely"}).translation("config.toms_storage.inv_link_beacon_lvl").defineInRange("invLinkBeaconLvl", 0, -1, 4);
            this.invLinkBeaconRange = builder.comment(new String[]{"Inventory Linking range with beacons", "Value of 0 disables this feature entirely"}).translation("config.toms_storage.inv_link_beacon_range").defineInRange("invLinkBeaconRange", 4096, 0, Integer.MAX_VALUE);
            this.invLinkBeaconLvlSameDim = builder.comment(new String[]{"Inventory Cable Connector requied beacon level for same dimension access with unlimited range", "Value of 0 only requires a single beacon block", "Value of -1 disables this feature entirely"}).translation("config.toms_storage.inv_link_beacon_lvl_same_dim").defineInRange("invLinkBeaconLvlSameDim", 1, -1, 4);
            this.invLinkBeaconLvlCrossDim = builder.comment(new String[]{"Inventory Cable Connector requied beacon level for cross dimensional access", "Value of 0 only requires a single beacon block", "Value of -1 disables this feature entirely"}).translation("config.toms_storage.inv_link_beacon_lvl_dim").defineInRange("invLinkBeaconLvlCrossDim", 2, -1, 4);
            this.runMultithreaded = builder.comment("Use multithreading to improve performance").translation("config.toms_storage.run_multithreaded").define("runMultithreaded", true);
        }
    }

    public static class Common {
        public ModConfigSpec.ConfigValue<List<? extends String>> blockedMods;
        public ModConfigSpec.ConfigValue<List<? extends String>> blockedBlocks;

        public Common(ModConfigSpec.Builder builder) {
            builder.comment(new String[]{"IMPORTANT NOTICE:", "THIS IS ONLY THE COMMON CONFIG. It does not contain all the values adjustable for Tom's Simple Storage", "The settings have been moved to toms_storage-server.toml", "That file is PER WORLD, meaning you have to go into 'saves/<world name>/serverconfig' to adjust it. Those changes will then only apply for THAT WORLD.", "You can then take that config file and put it in the 'defaultconfigs' folder to make it apply automatically to all NEW worlds you generate FROM THERE ON.", "This may appear confusing to many of you, but it is a new sensible way to handle configuration, because the server configuration is synced when playing multiplayer."}).define("importantInfo", true);
            this.blockedMods = builder.comment("List of mod ids whose blocks is ignored by the inventory connector").translation("config.toms_storage.inv_blocked_mods").defineList("blockedMods", Collections.emptyList(), () -> "", s -> true);
            this.blockedBlocks = builder.comment("List of block ids ignored by the inventory connector").translation("config.toms_storage.inv_blocked_blocks").defineList("blockedBlocks", Collections.emptyList(), () -> "", s -> true);
        }
    }
}

