/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.registry;

import java.util.EnumMap;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import ovh.corail.tombstone.helper.DamageCategory;
import ovh.corail.tombstone.registry.ModItems;

public final class ModTags {

    public static class DamageTypes {
        public static final TagKey<DamageType> EARTH = DamageTypes.tag("earth");
        public static final TagKey<DamageType> FIRE = DamageTypes.tag("fire");
        public static final TagKey<DamageType> AIR = DamageTypes.tag("air");
        public static final TagKey<DamageType> WATER = DamageTypes.tag("water");
        public static final TagKey<DamageType> DARKNESS = DamageTypes.tag("darkness");
        public static final TagKey<DamageType> LIGHT = DamageTypes.tag("light");

        private static TagKey<DamageType> tag(String name) {
            return TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)name));
        }
    }

    public static class EntityTypes {
        public static final TagKey<EntityType<?>> UNHANDLED_TAMABLE = EntityTypes.tag("unhandled_tamable");
        public static final TagKey<EntityType<?>> UNHANDLED_TAMABLE_UNDEADS = EntityTypes.tag("unhandled_tamable_undeads");
        public static final TagKey<EntityType<?>> INCREASE_ALIGNMENT = EntityTypes.tag("increase_alignment");
        public static final TagKey<EntityType<?>> DECREASE_ALIGNMENT = EntityTypes.tag("decrease_alignment");

        private static TagKey<EntityType<?>> tag(String name) {
            return TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)name));
        }
    }

    public static class Items {
        public static final EnumMap<DamageCategory, TagKey<Item>> VOODOO_POPPET_INGREDIENT_BY_TYPE = new EnumMap(ModItems.voodoo_poppet.getValidDamageTypes().collect(Collectors.toMap(UnaryOperator.identity(), d -> Items.tag("voodoo_poppet_ingredient_" + d.getSerializedName()))));
        public static final TagKey<Item> enchanted_grave_key_ingredients = Items.tag("enchanted_grave_key_ingredients");
        public static final TagKey<Item> magic_scrolls = Items.tag("magic_scrolls");
        public static final TagKey<Item> magic_tablets = Items.tag("magic_tablets");
        public static final TagKey<Item> magic_books = Items.tag("magic_books");
        public static final TagKey<Item> decorative_graves = Items.tag("decorative_graves");
        public static final TagKey<Item> grave_marbles = Items.tag("grave_marbles");
        public static final TagKey<Item> seeds = Items.tag("seeds");
        public static final TagKey<Item> any_weapon = Items.tag("enchantable/any_weapon");
        public static final TagKey<Item> lootable_weapon = Items.tag("lootable/weapon");
        public static final TagKey<Item> lootable_armor = Items.tag("lootable/armor");
        public static final TagKey<Item> lootable_tool = Items.tag("lootable/tool");
        public static final TagKey<Item> lootable_vanilla_weapon = Items.tag("lootable/vanilla_weapon");
        public static final TagKey<Item> lootable_vanilla_armor = Items.tag("lootable/vanilla_armor");
        public static final TagKey<Item> lootable_vanilla_tool = Items.tag("lootable/vanilla_tool");

        private static TagKey<Item> tag(String name) {
            return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)name));
        }
    }

    public static class Blocks {
        public static final TagKey<Block> graves = Blocks.tag("graves");
        public static final TagKey<Block> decorative_graves = Blocks.tag("decorative_graves");
        public static final TagKey<Block> grave_marbles = Blocks.tag("grave_marbles");
        public static final TagKey<Block> prayable = Blocks.tag("prayable");

        private static TagKey<Block> tag(String name) {
            return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)name));
        }
    }
}

