/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.registry;

import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.EnumMap;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.registries.RegisterEvent;
import ovh.corail.tombstone.block.BlockAbandonedGrave;
import ovh.corail.tombstone.block.BlockDecorativeGrave;
import ovh.corail.tombstone.block.BlockGrave;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.blockEntity.BlockEntityDecorativeGrave;
import ovh.corail.tombstone.blockEntity.BlockEntityPlayerGrave;
import ovh.corail.tombstone.helper.Helper;

public final class ModBlocks {
    public static final EnumMap<GraveModel, Block> PLAYER_GRAVES = new EnumMap(GraveModel.class);
    public static final EnumMap<GraveModel, Block> DECORATIVE_GRAVES = new EnumMap(GraveModel.class);
    public static BlockEntityType<BlockEntityPlayerGrave> tile_grave = (BlockEntityType)Helper.unsafeNullCast();
    public static BlockEntityType<BlockEntityDecorativeGrave> tile_decorative_grave = (BlockEntityType)Helper.unsafeNullCast();
    public static Block abandoned_grave = (Block)Helper.unsafeNullCast();
    public static Block dark_marble = (Block)Helper.unsafeNullCast();
    public static Block white_marble = (Block)Helper.unsafeNullCast();
    public static Block blue_marble = (Block)Helper.unsafeNullCast();
    public static Block green_marble = (Block)Helper.unsafeNullCast();
    public static Block carmin_marble = (Block)Helper.unsafeNullCast();
    public static Block dark_marble_slab = (Block)Helper.unsafeNullCast();
    public static Block white_marble_slab = (Block)Helper.unsafeNullCast();
    public static Block blue_marble_slab = (Block)Helper.unsafeNullCast();
    public static Block green_marble_slab = (Block)Helper.unsafeNullCast();
    public static Block carmin_marble_slab = (Block)Helper.unsafeNullCast();
    public static Block dark_marble_stairs = (Block)Helper.unsafeNullCast();
    public static Block white_marble_stairs = (Block)Helper.unsafeNullCast();
    public static Block blue_marble_stairs = (Block)Helper.unsafeNullCast();
    public static Block green_marble_stairs = (Block)Helper.unsafeNullCast();
    public static Block carmin_marble_stairs = (Block)Helper.unsafeNullCast();
    public static Block dark_marble_wall = (Block)Helper.unsafeNullCast();
    public static Block white_marble_wall = (Block)Helper.unsafeNullCast();
    public static Block blue_marble_wall = (Block)Helper.unsafeNullCast();
    public static Block green_marble_wall = (Block)Helper.unsafeNullCast();
    public static Block carmin_marble_wall = (Block)Helper.unsafeNullCast();

    public static boolean isPlayerGrave(Block block) {
        return PLAYER_GRAVES.containsValue(block);
    }

    public static boolean isDecorativeGrave(Block block) {
        return DECORATIVE_GRAVES.containsValue(block);
    }

    public static boolean isAnyGrave(Block block) {
        return ModBlocks.isPlayerGrave(block) || ModBlocks.isDecorativeGrave(block);
    }

    static void onRegisterBlocks(RegisterEvent event) {
        Arrays.stream(GraveModel.values()).forEach(model -> {
            BlockGrave playerGrave = new BlockGrave((GraveModel)((Object)model));
            PLAYER_GRAVES.put((GraveModel)((Object)model), (Block)playerGrave);
            ModBlocks.register(event, (Block)playerGrave, model.getSerializedName());
            BlockDecorativeGrave decorativeGrave = new BlockDecorativeGrave((GraveModel)((Object)model));
            DECORATIVE_GRAVES.put((GraveModel)((Object)model), (Block)decorativeGrave);
            ModBlocks.register(event, (Block)decorativeGrave, "decorative_" + model.getSerializedName());
        });
        abandoned_grave = new BlockAbandonedGrave();
        ModBlocks.register(event, abandoned_grave, "abandoned_grave");
        dark_marble = new BlockGraveMarble(BlockGraveMarble.MarbleType.DARK);
        ModBlocks.register(event, dark_marble, "dark_marble");
        white_marble = new BlockGraveMarble(BlockGraveMarble.MarbleType.WHITE);
        ModBlocks.register(event, white_marble, "white_marble");
        blue_marble = new BlockGraveMarble(BlockGraveMarble.MarbleType.BLUE);
        ModBlocks.register(event, blue_marble, "blue_marble");
        green_marble = new BlockGraveMarble(BlockGraveMarble.MarbleType.GREEN);
        ModBlocks.register(event, green_marble, "green_marble");
        carmin_marble = new BlockGraveMarble(BlockGraveMarble.MarbleType.CARMIN);
        ModBlocks.register(event, carmin_marble, "carmin_marble");
        dark_marble_slab = new SlabBlock(BlockGraveMarble.getBuilder());
        ModBlocks.register(event, dark_marble_slab, "dark_marble_slab");
        white_marble_slab = new SlabBlock(BlockGraveMarble.getBuilder());
        ModBlocks.register(event, white_marble_slab, "white_marble_slab");
        blue_marble_slab = new SlabBlock(BlockGraveMarble.getBuilder());
        ModBlocks.register(event, blue_marble_slab, "blue_marble_slab");
        green_marble_slab = new SlabBlock(BlockGraveMarble.getBuilder());
        ModBlocks.register(event, green_marble_slab, "green_marble_slab");
        carmin_marble_slab = new SlabBlock(BlockGraveMarble.getBuilder());
        ModBlocks.register(event, carmin_marble_slab, "carmin_marble_slab");
        dark_marble_stairs = new StairBlock(dark_marble.defaultBlockState(), BlockGraveMarble.getBuilder());
        ModBlocks.register(event, dark_marble_stairs, "dark_marble_stairs");
        white_marble_stairs = new StairBlock(white_marble.defaultBlockState(), BlockGraveMarble.getBuilder());
        ModBlocks.register(event, white_marble_stairs, "white_marble_stairs");
        blue_marble_stairs = new StairBlock(blue_marble.defaultBlockState(), BlockGraveMarble.getBuilder());
        ModBlocks.register(event, blue_marble_stairs, "blue_marble_stairs");
        green_marble_stairs = new StairBlock(green_marble.defaultBlockState(), BlockGraveMarble.getBuilder());
        ModBlocks.register(event, green_marble_stairs, "green_marble_stairs");
        carmin_marble_stairs = new StairBlock(carmin_marble.defaultBlockState(), BlockGraveMarble.getBuilder());
        ModBlocks.register(event, carmin_marble_stairs, "carmin_marble_stairs");
        dark_marble_wall = new WallBlock(BlockGraveMarble.getBuilder());
        ModBlocks.register(event, dark_marble_wall, "dark_marble_wall");
        white_marble_wall = new WallBlock(BlockGraveMarble.getBuilder());
        ModBlocks.register(event, white_marble_wall, "white_marble_wall");
        blue_marble_wall = new WallBlock(BlockGraveMarble.getBuilder());
        ModBlocks.register(event, blue_marble_wall, "blue_marble_wall");
        green_marble_wall = new WallBlock(BlockGraveMarble.getBuilder());
        ModBlocks.register(event, green_marble_wall, "green_marble_wall");
        carmin_marble_wall = new WallBlock(BlockGraveMarble.getBuilder());
        ModBlocks.register(event, carmin_marble_wall, "carmin_marble_wall");
    }

    static void onRegisterBlockItems(RegisterEvent event) {
        DECORATIVE_GRAVES.forEach((key, value) -> ModBlocks.register(event, new ItemBlockGrave((Block)value), "decorative_" + key.getSerializedName()));
        ModBlocks.register(event, new BlockItem(dark_marble, new Item.Properties()), "dark_marble");
        ModBlocks.register(event, new BlockItem(white_marble, new Item.Properties()), "white_marble");
        ModBlocks.register(event, new BlockItem(blue_marble, new Item.Properties()), "blue_marble");
        ModBlocks.register(event, new BlockItem(green_marble, new Item.Properties()), "green_marble");
        ModBlocks.register(event, new BlockItem(carmin_marble, new Item.Properties()), "carmin_marble");
        ModBlocks.register(event, new BlockItem(dark_marble_slab, new Item.Properties()), "dark_marble_slab");
        ModBlocks.register(event, new BlockItem(white_marble_slab, new Item.Properties()), "white_marble_slab");
        ModBlocks.register(event, new BlockItem(blue_marble_slab, new Item.Properties()), "blue_marble_slab");
        ModBlocks.register(event, new BlockItem(green_marble_slab, new Item.Properties()), "green_marble_slab");
        ModBlocks.register(event, new BlockItem(carmin_marble_slab, new Item.Properties()), "carmin_marble_slab");
        ModBlocks.register(event, new BlockItem(dark_marble_stairs, new Item.Properties()), "dark_marble_stairs");
        ModBlocks.register(event, new BlockItem(white_marble_stairs, new Item.Properties()), "white_marble_stairs");
        ModBlocks.register(event, new BlockItem(blue_marble_stairs, new Item.Properties()), "blue_marble_stairs");
        ModBlocks.register(event, new BlockItem(green_marble_stairs, new Item.Properties()), "green_marble_stairs");
        ModBlocks.register(event, new BlockItem(carmin_marble_stairs, new Item.Properties()), "carmin_marble_stairs");
        ModBlocks.register(event, new BlockItem(dark_marble_wall, new Item.Properties()), "dark_marble_wall");
        ModBlocks.register(event, new BlockItem(white_marble_wall, new Item.Properties()), "white_marble_wall");
        ModBlocks.register(event, new BlockItem(blue_marble_wall, new Item.Properties()), "blue_marble_wall");
        ModBlocks.register(event, new BlockItem(green_marble_wall, new Item.Properties()), "green_marble_wall");
        ModBlocks.register(event, new BlockItem(carmin_marble_wall, new Item.Properties()), "carmin_marble_wall");
    }

    static void onRegisterBlockTypes(RegisterEvent event) {
        ModBlocks.register(BlockDecorativeGrave.CODEC, "decorative_grave");
        ModBlocks.register(BlockGrave.CODEC, "player_grave");
    }

    static void onRegisterBlockEntityTypes(RegisterEvent event) {
        tile_decorative_grave = BlockEntityType.Builder.of(BlockEntityDecorativeGrave::new, (Block[])DECORATIVE_GRAVES.values().toArray(new Block[0])).build(null);
        ModBlocks.register(event, tile_decorative_grave, "tile_decorative_grave");
        tile_grave = BlockEntityType.Builder.of(BlockEntityPlayerGrave::new, (Block[])PLAYER_GRAVES.values().toArray(new Block[0])).build(null);
        ModBlocks.register(event, tile_grave, "tile_grave");
    }

    private static void register(RegisterEvent event, Block block, String name) {
        event.register(Registries.BLOCK, ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)name), () -> block);
    }

    private static void register(RegisterEvent event, BlockItem blockItem, String name) {
        event.register(Registries.ITEM, ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)name), () -> blockItem);
    }

    private static void register(RegisterEvent event, BlockEntityType<?> blockEntityType, String name) {
        event.register(Registries.BLOCK_ENTITY_TYPE, ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)name), () -> blockEntityType);
    }

    private static void register(MapCodec<? extends Block> blockType, String name) {
        Registry.register((Registry)BuiltInRegistries.BLOCK_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)name), blockType);
    }
}

