/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.registry;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.NoopRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.combine.ClientTooltipCombineCraft;
import ovh.corail.tombstone.combine.ClientTooltipCombineUpgrade;
import ovh.corail.tombstone.combine.ClientTooltipSimple;
import ovh.corail.tombstone.combine.TooltipCombineCraft;
import ovh.corail.tombstone.combine.TooltipCombineUpgrade;
import ovh.corail.tombstone.combine.TooltipDyeable;
import ovh.corail.tombstone.combine.TooltipEngravable;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.item.ItemGraveMagic;
import ovh.corail.tombstone.item.ItemLostTablet;
import ovh.corail.tombstone.particle.ParticleGhost;
import ovh.corail.tombstone.particle.ParticleSmokeCloud;
import ovh.corail.tombstone.particle.ParticleSmokeColumn;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEntities;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModKeybinds;
import ovh.corail.tombstone.registry.ModParticleTypes;
import ovh.corail.tombstone.render.GraveGuardianRenderer;
import ovh.corail.tombstone.render.RenderWritableGrave;
import ovh.corail.tombstone.render.SpectralBiteRenderer;
import ovh.corail.tombstone.render.SpectralWolfRenderer;

@EventBusSubscriber(modid="tombstone", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public final class ClientModEvents {
    @Nullable
    private static ShaderInstance lowAlphaShader;

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tint) -> tint == 0 ? -9865852 : -1, new ItemLike[]{ModItems.book_of_disenchantment});
        event.register((stack, tint) -> tint == 0 ? -7252579 : -1, new ItemLike[]{ModItems.book_of_recycling});
        event.register((stack, tint) -> tint == 0 ? -11246691 : -1, new ItemLike[]{ModItems.book_of_repairing});
        event.register((stack, tint) -> tint == 0 ? -4934259 : -1, new ItemLike[]{ModItems.book_of_scribe});
        event.register((stack, tint) -> tint == 0 ? -11806832 : -1, new ItemLike[]{ModItems.book_of_magic_impregnation});
        event.register((stack, tint) -> tint == 0 ? -1338828 : -1, new ItemLike[]{ModItems.book_of_soulbound});
        event.register((stack, tint) -> tint == 0 ? -8199699 : -1, new ItemLike[]{ModItems.book_of_oblivion});
        event.register((stack, tint) -> tint == 0 ? -16711904 : -16733664, new ItemLike[]{ModItems.dust_of_vanishing});
        event.register((stack, tint) -> tint == 0 ? -16760672 : -16756550, new ItemLike[]{ModItems.grave_dust});
        event.register((stack, tint) -> -6238048, new ItemLike[]{ModItems.dust_of_frost});
        event.register(ModItems.lollipop::getColor, new ItemLike[]{ModItems.lollipop});
        event.register(ModItems.easter_egg::getColor, new ItemLike[]{ModItems.easter_egg});
        event.register(ModItems.smoke_ball::getColor, new ItemLike[]{ModItems.smoke_ball});
        event.register(ModItems.magic_scroll::getColor, new ItemLike[]{ModItems.magic_scroll});
        event.register((stack, tint) -> tint == 0 && ModItems.scroll_of_knowledge.isEnchanted(stack) ? -16711936 : -1, new ItemLike[]{ModItems.scroll_of_knowledge});
        event.register((stack, tint) -> tint == 0 ? -15472641 : -1, new ItemLike[]{ModItems.gemstone_of_familiar});
        event.register((stack, tint) -> tint == 0 ? -2423297 : -1, new ItemLike[]{ModItems.gemstone_of_merchant});
        event.register((stack, tint) -> tint == 0 ? -8700161 : -1, new ItemLike[]{ModItems.gemstone_of_prayer});
        event.register((stack, tint) -> tint == 0 ? -15756769 : -1, new ItemLike[]{ModItems.gemstone_of_guardian});
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(ModBlocks.tile_decorative_grave, RenderWritableGrave::new);
        event.registerBlockEntityRenderer(ModBlocks.tile_grave, RenderWritableGrave::new);
        event.registerEntityRenderer(ModEntities.cloud, NoopRenderer::new);
        event.registerEntityRenderer(ModEntities.spectral_bite, SpectralBiteRenderer::new);
        event.registerEntityRenderer(ModEntities.spectral_wolf, SpectralWolfRenderer::new);
        event.registerEntityRenderer(ModEntities.grave_guardian, GraveGuardianRenderer::new);
    }

    public static ShaderInstance getLowAlphaShader() {
        return Objects.requireNonNull(Optional.ofNullable(lowAlphaShader).orElse(GameRenderer.getParticleShader()));
    }

    @SubscribeEvent
    public static void onRegisterShaders(RegisterShadersEvent event) throws IOException {
        event.registerShader(new ShaderInstance(event.getResourceProvider(), ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"alphal"), DefaultVertexFormat.PARTICLE), shaderInstance -> {
            lowAlphaShader = shaderInstance;
        });
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        ParticleEngine particleEngine = Minecraft.getInstance().particleEngine;
        particleEngine.register((ParticleType)ModParticleTypes.GHOST, (type, level, x, y, z, mX, mY, mZ) -> new ParticleGhost(level, x, y, z, (Helper.RANDOM.nextDouble() - 0.5) * 0.1, (Helper.RANDOM.nextDouble() - 0.5) * 0.1));
        particleEngine.register((ParticleType)ModParticleTypes.SMOKE_COLUMN, (type, level, x, y, z, mX, mY, mZ) -> new ParticleSmokeColumn(level, x, y, z));
        particleEngine.register((ParticleType)ModParticleTypes.SMOKE_CLOUD, (type, level, x, y, z, mX, mY, mZ) -> new ParticleSmokeCloud(level, x, y, z));
    }

    @SubscribeEvent
    public static void onRegisterTooltipComponentFactory(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(TooltipCombineCraft.class, ClientTooltipCombineCraft::new);
        event.register(TooltipCombineUpgrade.class, ClientTooltipCombineUpgrade::new);
        event.register(TooltipDyeable.class, ClientTooltipSimple::new);
        event.register(TooltipEngravable.class, ClientTooltipSimple::new);
    }

    @SubscribeEvent
    public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        ModKeybinds.KEYBIND_KNOWLEDGE = new KeyMapping(LangKey.MESSAGE_KNOWLEDGE_OF_DEATH.getKey(), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.UNKNOWN, "Corail Tombstone");
        event.register(ModKeybinds.KEYBIND_KNOWLEDGE);
        ModKeybinds.KEYBIND_CONFIG = new KeyMapping(LangKey.MESSAGE_CONFIG.getKey(), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.UNKNOWN, "Corail Tombstone");
        event.register(ModKeybinds.KEYBIND_CONFIG);
        ModKeybinds.KEYBIND_COMPENDIUM = new KeyMapping(LangKey.MESSAGE_COMPENDIUM.getKey(), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.UNKNOWN, "Corail Tombstone");
        event.register(ModKeybinds.KEYBIND_COMPENDIUM);
    }

    public static void initModels() {
        for (Block decorativeGrave : ModBlocks.DECORATIVE_GRAVES.values()) {
            ItemProperties.register((Item)decorativeGrave.asItem(), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"model_texture"), (stack, world, entity, aInt) -> (EngravableHelper.isEngraved(stack) ? 0.1f : 0.0f) + (float)ItemBlockGrave.getModelTexture(stack) * 0.01f);
        }
        ItemProperties.register((Item)ModItems.bone_needle, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"filled"), (stack, world, entity, aInt) -> ModItems.bone_needle.getEntityType(stack).isEmpty() ? 0.0f : 1.0f);
        ItemProperties.register((Item)ModItems.lost_tablet, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"type"), (stack, world, player, aInt) -> switch (ModItems.lost_tablet.getType(stack)) {
            default -> throw new MatchException(null, null);
            case ItemLostTablet.Type.UNKNOWN -> 0.0f;
            case ItemLostTablet.Type.EXPLORATION -> 0.1f;
            case ItemLostTablet.Type.VILLAGE -> 0.5f;
            case ItemLostTablet.Type.TREASURE -> 1.0f;
        });
        ResourceLocation rlMagic = ResourceLocation.withDefaultNamespace((String)"magic");
        ItemPropertyFunction isMagic = (stack, worldIn, entityIn, aInt) -> {
            ItemGraveMagic itemGraveMagic = (ItemGraveMagic)stack.getItem();
            return itemGraveMagic.isAncient(stack) ? 1.0f : (itemGraveMagic.isEnchanted(stack) ? 0.5f : 0.0f);
        };
        ModItems.scroll_buff.values().forEach(item -> ItemProperties.register((Item)item, (ResourceLocation)rlMagic, (ItemPropertyFunction)isMagic));
        ItemPropertyFunction isAncient = (stack, worldIn, entityIn, aInt) -> ((ItemGraveMagic)stack.getItem()).isAncient(stack) ? 1.0f : 0.0f;
        ResourceLocation rlAncient = ResourceLocation.withDefaultNamespace((String)"ancient");
        ItemProperties.register((Item)ModItems.tablet_of_home, (ResourceLocation)rlAncient, (ItemPropertyFunction)isAncient);
        ItemProperties.register((Item)ModItems.tablet_of_recall, (ResourceLocation)rlAncient, (ItemPropertyFunction)isAncient);
        ItemProperties.register((Item)ModItems.tablet_of_assistance, (ResourceLocation)rlAncient, (ItemPropertyFunction)isAncient);
        ItemProperties.register((Item)ModItems.tablet_of_cupidity, (ResourceLocation)rlAncient, (ItemPropertyFunction)isAncient);
        ItemProperties.register((Item)ModItems.tablet_of_guard, (ResourceLocation)rlAncient, (ItemPropertyFunction)isAncient);
        ItemProperties.register((Item)ModItems.magic_scroll, (ResourceLocation)rlAncient, (ItemPropertyFunction)isAncient);
        ItemProperties.register((Item)ModItems.fishing_rod_of_misadventure, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"cast"), (stack, world, entity, aInt) -> {
            Player player;
            return (ModItems.fishing_rod_of_misadventure.isAncient(stack) ? 0.01f : 0.0f) + (entity instanceof Player && ((player = (Player)entity).getMainHandItem() == stack || player.getOffhandItem() == stack) && player.fishing != null ? 0.1f : 0.0f);
        });
        ItemProperties.register((Item)ModItems.grave_plate, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"engraved"), (stack, worldIn, entityIn, aInt) -> EngravableHelper.isEngraved(stack) ? 1.0f : 0.0f);
    }
}

