/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.perk;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.perk.Perk;
import ovh.corail.tombstone.registry.ModItems;

public final class PerkShadowWalker
extends Perk {
    public PerkShadowWalker() {
        super("shadow_walker", ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"textures/mob_effect/discretion.png"));
    }

    @Override
    public int getLevelMax() {
        return (Integer)SharedConfigTombstone.allowed_perks.levelMaxShadowWalker.get();
    }

    @Override
    public boolean isDisabled(@Nullable Player player) {
        return (Boolean)SharedConfigTombstone.allowed_perks.allowShadowWalker.get() == false;
    }

    @Override
    public List<Component> getCurrentBonusInfo(int level) {
        ArrayList<Component> bonus = new ArrayList<Component>();
        bonus.add((Component)Component.literal((String)("+" + level * 10 + "% ")).append((Component)Component.translatable((String)(this.getTranslationKey() + ".bonus1"))));
        if (level > 4) {
            bonus.add((Component)Component.translatable((String)(this.getTranslationKey() + ".bonus2")));
        }
        return bonus;
    }

    @Override
    public int getCost(int level) {
        return Math.max((int)1, (int)(level - 2));
    }

    @Override
    public int getLevelBonus(Player player) {
        int bonus;
        int n = bonus = player.getItemBySlot(EquipmentSlot.HEAD).getItem() == ModItems.rabbit_mask ? 2 : 0;
        if (TimeHelper.isDateAroundChristmas()) {
            bonus += 3;
        }
        return bonus;
    }
}

