/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.perk;

import java.util.Collections;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.perk.Perk;

public final class PerkJailer
extends Perk {
    public PerkJailer() {
        super("jailer", ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"textures/item/grave_key.png"));
    }

    @Override
    public int getLevelMax() {
        return (Integer)SharedConfigTombstone.allowed_perks.levelMaxJailer.get();
    }

    @Override
    public boolean isDisabled(@Nullable Player player) {
        return (Boolean)SharedConfigTombstone.allowed_perks.allowJailer.get() == false || (Boolean)SharedConfigTombstone.magic_item.alwaysEnchantGraveKey.get() != false;
    }

    @Override
    public Component getDisabledInfo(@Nullable Player player) {
        return (Boolean)SharedConfigTombstone.allowed_perks.allowJailer.get() != false ? Component.translatable((String)(this.getTranslationKey() + ".disabled")) : super.getDisabledInfo(player);
    }

    @Override
    public List<Component> getCurrentBonusInfo(int level) {
        return Collections.singletonList(Component.literal((String)(Math.min((int)(level * 20), (int)100) + "% ")).append((Component)Component.translatable((String)(this.getTranslationKey() + ".bonus"))));
    }

    @Override
    public int getCost(int level) {
        return Math.max((int)1, (int)(level - 2));
    }

    @Override
    public int getLevelBonus(Player player) {
        return TimeHelper.isDateAroundHalloween() || TimeHelper.isDateAroundChristmas() ? 5 : 0;
    }
}

