/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.perk;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.perk.Perk;

public final class PerkConcentration
extends Perk {
    public PerkConcentration() {
        super("concentration", ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"textures/mob_effect/concentration.png"));
    }

    @Override
    public int getLevelMax() {
        return (Integer)SharedConfigTombstone.allowed_perks.levelMaxConcentration.get();
    }

    @Override
    public boolean isDisabled(@Nullable Player player) {
        return (Boolean)SharedConfigTombstone.allowed_perks.allowConcentration.get() == false;
    }

    @Override
    public List<Component> getCurrentBonusInfo(int level) {
        ArrayList<Component> bonus = new ArrayList<Component>();
        bonus.add((Component)Component.literal((String)("+" + level * 15 + "% ")).append((Component)Component.translatable((String)(this.getTranslationKey() + ".bonus1"))));
        bonus.add((Component)Component.literal((String)("+" + level * 30 + "% ")).append((Component)Component.translatable((String)(this.getTranslationKey() + ".bonus2"))));
        return bonus;
    }

    @Override
    public int getLevelBonus(Player player) {
        return TimeHelper.isDateAroundEaster() || TimeHelper.isAprilFoolsDay() ? 3 : 0;
    }
}

