/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import ovh.corail.tombstone.particle.CustomParticle;

@OnlyIn(value=Dist.CLIENT)
abstract class BoundParticle
extends CustomParticle {
    private boolean initialized = false;
    protected final WeakReference<LivingEntity> entityWeakReference;
    protected final double radius;
    private final List<ParticleData> particleDatas = new ArrayList<ParticleData>();

    public BoundParticle(ClientLevel level, LivingEntity entity, double radius) {
        super(level, entity.position());
        this.entityWeakReference = new WeakReference<LivingEntity>(entity);
        this.radius = radius;
        this.setLifetime(20);
        this.setSize(4.0f, 2.0f);
    }

    protected abstract void addParticleDatas(List<ParticleData> var1);

    protected void onParticleDataUpdate(ParticleData data, double ratio) {
        Vec3 newPos = new Vec3(this.x, this.y, this.z).add(this.radius * Math.cos(6.2831854820251465 * (data.angle + ratio)), data.yHeight, this.radius * Math.sin(6.2831854820251465 * (data.angle + ratio)));
        data.oPos = data.pos == null ? newPos : data.pos;
        data.pos = newPos;
    }

    @Override
    @Deprecated
    public Particle scale(float scale) {
        return this;
    }

    @Override
    public void setRolling(float rollIncrement) {
        this.setRolling(0.0f, rollIncrement);
    }

    @Override
    protected boolean requireRemoval() {
        return this.age >= this.lifetime + 1;
    }

    @Override
    public void tick() {
        LivingEntity entity = (LivingEntity)this.entityWeakReference.get();
        if (entity == null) {
            this.remove();
            return;
        }
        if (!this.initialized) {
            this.updateLastPos();
            this.addParticleDatas(this.particleDatas);
            this.initialized = true;
        }
        if (this.requireRemoval()) {
            this.remove();
        } else {
            ++this.age;
            double ratio = (double)(entity.tickCount % 100) / 100.0;
            this.updateLastPos();
            this.setPos(entity.getX(), entity.getY(), entity.getZ());
            this.update();
            this.particleDatas.forEach(data -> this.onParticleDataUpdate((ParticleData)data, ratio));
        }
    }

    @Override
    public void render(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        if (this.age <= 1) {
            return;
        }
        float rot = Mth.lerp((float)partialTicks, (float)this.oRoll, (float)this.roll);
        for (ParticleData data : this.particleDatas) {
            Quaternionf rollTransform;
            Vec3 vecFromCamera = new Vec3(Mth.lerp((double)partialTicks, (double)data.oPos.x, (double)data.pos.x), Mth.lerp((double)partialTicks, (double)data.oPos.y, (double)data.pos.y), Mth.lerp((double)partialTicks, (double)data.oPos.z, (double)data.pos.z)).subtract(renderInfo.getPosition());
            int light = this.getLightColor(partialTicks);
            if (this.roll == 0.0f) {
                rollTransform = renderInfo.rotation();
            } else {
                rollTransform = new Quaternionf((Quaternionfc)renderInfo.rotation());
                rollTransform.mul((Quaternionfc)Axis.ZP.rotation(rot + data.startRoll));
            }
            Vector3f[] vecFaceQuad = this.getFaceQuad();
            Arrays.stream(vecFaceQuad).forEach(v -> {
                v.rotate((Quaternionfc)rollTransform);
                v.mul(data.size);
                v.add((float)vecFromCamera.x, (float)vecFromCamera.y, (float)vecFromCamera.z);
            });
            this.addQuad(buffer, vecFaceQuad, light);
        }
    }

    protected class ParticleData {
        protected float size;
        protected float startRoll;
        protected double angle;
        protected double yHeight;
        protected Vec3 oPos;
        protected Vec3 pos;

        protected ParticleData(BoundParticle this$0, float size, double angle, double yHeight) {
            this(this$0, size, angle, yHeight, 0.0f);
        }

        protected ParticleData(BoundParticle this$0, float size, double angle, double yHeight, float startRoll) {
            this.size = size * 0.2f;
            this.angle = angle;
            this.yHeight = yHeight;
            this.startRoll = startRoll;
        }
    }
}

