/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.capability.PlayerKnowledgeHandler;
import ovh.corail.tombstone.network.CMessagePlayerCapSetPerk;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.perk.Perk;
import ovh.corail.tombstone.perk.PerkRegistry;
import ovh.corail.tombstone.registry.ModTriggers;

public record SMessageUpgradePerk(SyncType syncType, @Nullable Perk perk) implements CustomPacketPayload
{
    static final CustomPacketPayload.Type<SMessageUpgradePerk> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"upgrade_perk"));
    static final StreamCodec<ByteBuf, SMessageUpgradePerk> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, msg -> msg.syncType == SyncType.DOWNGRADE_PERK, (StreamCodec)ByteBufCodecs.STRING_UTF8, msg -> Optional.ofNullable(msg.perk).map(PerkRegistry::getKey).map(ResourceLocation::toString).orElse(""), (syncType, perkString) -> new SMessageUpgradePerk(syncType != false ? SyncType.DOWNGRADE_PERK : SyncType.UPGRADE_PERK, PerkRegistry.getValue(perkString)));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    static void handle(SMessageUpgradePerk msg, IPayloadContext ctx) {
        ServerPlayer player = (ServerPlayer)ctx.player();
        if (msg.perk != null && !msg.perk.isDisabled((Player)player)) {
            int levelPerk = PlayerKnowledgeHandler.getPerkLevel((Player)player, msg.perk);
            int totalPerkPoints = PlayerKnowledgeHandler.getTotalPerkPoints((Player)player);
            if (msg.syncType == SyncType.UPGRADE_PERK && levelPerk < Math.min(msg.perk.getLevelMax(), totalPerkPoints) && totalPerkPoints - PlayerKnowledgeHandler.getUsedPerkPoints((Player)player) >= msg.perk.getCost(levelPerk + 1)) {
                PlayerKnowledgeHandler.setPerk((Player)player, msg.perk, levelPerk + 1);
                ModTriggers.selected_perks.trigger(player);
                PacketHandler.sendToPlayer(new CMessagePlayerCapSetPerk(msg.perk, levelPerk + 1), player);
            } else if (msg.syncType == SyncType.DOWNGRADE_PERK && levelPerk > 0 && player.isCreative()) {
                PlayerKnowledgeHandler.setPerk((Player)player, msg.perk, levelPerk - 1);
                PacketHandler.sendToPlayer(new CMessagePlayerCapSetPerk(msg.perk, levelPerk - 1), player);
            }
        }
    }

    public static enum SyncType {
        UPGRADE_PERK,
        DOWNGRADE_PERK;

    }
}

