/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import ovh.corail.tombstone.capability.SpellCasterHandler;
import ovh.corail.tombstone.helper.ProxyHelper;

public record CMessageSpellCasting(int entityId, int color) implements CustomPacketPayload
{
    static final CustomPacketPayload.Type<CMessageSpellCasting> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"spell_casting"));
    static final StreamCodec<ByteBuf, CMessageSpellCasting> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, CMessageSpellCasting::entityId, (StreamCodec)ByteBufCodecs.INT, CMessageSpellCasting::color, CMessageSpellCasting::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    static void handle(CMessageSpellCasting msg, IPayloadContext ctx) {
        ProxyHelper.getClientWorld().map(level -> level.getEntity(msg.entityId)).filter(LivingEntity.class::isInstance).map(LivingEntity.class::cast).ifPresent(caster -> {
            if (SpellCasterHandler.hasCapability(caster)) {
                SpellCasterHandler.setCastingColor(caster, msg.color);
                if (SpellCasterHandler.isCasting(caster)) {
                    ProxyHelper.produceParticleCasting(1.0, msg.color, caster, e -> !SpellCasterHandler.isCasting(e));
                }
            }
        });
    }
}

