/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import ovh.corail.tombstone.helper.ProxyHelper;

public record CMessageSmokeColumn(Vec3 posVec) implements CustomPacketPayload
{
    static final CustomPacketPayload.Type<CMessageSmokeColumn> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"smoke_column"));
    static StreamCodec<ByteBuf, Vec3> VEC3 = new StreamCodec<ByteBuf, Vec3>(){

        public Vec3 decode(ByteBuf buf) {
            return new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        }

        public void encode(ByteBuf buf, Vec3 posVec) {
            buf.writeDouble(posVec.x);
            buf.writeDouble(posVec.y);
            buf.writeDouble(posVec.z);
        }
    };
    static final StreamCodec<ByteBuf, CMessageSmokeColumn> STREAM_CODEC = StreamCodec.composite(VEC3, CMessageSmokeColumn::posVec, CMessageSmokeColumn::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    static void handle(CMessageSmokeColumn msg, IPayloadContext ctx) {
        ProxyHelper.getClientWorld().ifPresent(level -> ProxyHelper.produceSmokeColumn(level, msg.posVec));
    }
}

