/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.ProxyHelper;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;

public record CMessagePrayer(int entityId, UUID prayerUUID, int prayType, int leftTime) implements CustomPacketPayload
{
    static final CustomPacketPayload.Type<CMessagePrayer> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"prayer"));
    static StreamCodec<ByteBuf, UUID> UUID = new StreamCodec<ByteBuf, UUID>(){

        public UUID decode(ByteBuf buf) {
            return ((FriendlyByteBuf)buf).readUUID();
        }

        public void encode(ByteBuf buf, UUID uuid) {
            ((FriendlyByteBuf)buf).writeUUID(uuid);
        }
    };
    static final StreamCodec<ByteBuf, CMessagePrayer> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, CMessagePrayer::entityId, UUID, CMessagePrayer::prayerUUID, (StreamCodec)ByteBufCodecs.SHORT, cMessagePrayer -> (short)cMessagePrayer.prayType(), (StreamCodec)ByteBufCodecs.INT, CMessagePrayer::leftTime, (entityId, prayerUUID, prayType, leftTime) -> new CMessagePrayer((int)entityId, (UUID)prayerUUID, prayType.shortValue(), (int)leftTime));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    static void handle(CMessagePrayer msg, IPayloadContext ctx) {
        Level level = ProxyHelper.getClientWorld().orElse(null);
        if (level != null) {
            CompoundTag tag;
            Player prayer = level.getPlayerByUUID(msg.prayerUUID);
            LivingEntity target = Optional.ofNullable(level.getEntity(msg.entityId)).filter(LivingEntity.class::isInstance).map(LivingEntity.class::cast).orElse(null);
            if (prayer != null && target != null && !(tag = target.getPersistentData()).hasUUID("prayer")) {
                tag.putUUID("prayer", msg.prayerUUID);
                EffectHelper.addEffect(target, ModEffects.prayer, msg.leftTime);
                ProxyHelper.producePray(target, msg.prayType, e -> !target.getPersistentData().hasUUID("prayer") || !prayer.isUsingItem() || !prayer.getMainHandItem().is((Item)ModItems.ankh_of_prayer));
            }
        }
    }
}

