/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.capability.PlayerKnowledgeHandler;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.ProxyHelper;
import ovh.corail.tombstone.perk.Perk;

public record CMessagePlayerCapSyncPerks(Map<Perk, Integer> perks) implements CustomPacketPayload
{
    static final CustomPacketPayload.Type<CMessagePlayerCapSyncPerks> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"player_cap_sync_perks"));
    static StreamCodec<ByteBuf, Map<Perk, Integer>> PERKS = new StreamCodec<ByteBuf, Map<Perk, Integer>>(){

        public Map<Perk, Integer> decode(ByteBuf buf) {
            @Nullable CompoundTag tag = ((FriendlyByteBuf)buf).readNbt();
            HashMap<Perk, Integer> perks = new HashMap<Perk, Integer>();
            if (tag != null) {
                NBTStackHelper.readPerks(perks, tag);
            }
            return perks;
        }

        public void encode(ByteBuf buf, Map<Perk, Integer> perks) {
            CompoundTag tag = new CompoundTag();
            NBTStackHelper.writePerks(perks, tag);
            ((FriendlyByteBuf)buf).writeNbt((Tag)tag);
        }
    };
    static final StreamCodec<ByteBuf, CMessagePlayerCapSyncPerks> STREAM_CODEC = StreamCodec.composite(PERKS, CMessagePlayerCapSyncPerks::perks, CMessagePlayerCapSyncPerks::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    static void handle(CMessagePlayerCapSyncPerks msg, IPayloadContext ctx) {
        ProxyHelper.getClientPlayer().ifPresent(player -> PlayerKnowledgeHandler.setPerks(player, msg.perks));
    }
}

