/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.capability.PlayerKnowledgeHandler;
import ovh.corail.tombstone.helper.ProxyHelper;
import ovh.corail.tombstone.perk.Perk;
import ovh.corail.tombstone.perk.PerkRegistry;

public record CMessagePlayerCapSetPerk(@Nullable Perk perk, int level) implements CustomPacketPayload
{
    static final CustomPacketPayload.Type<CMessagePlayerCapSetPerk> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"player_cap_set_perk"));
    static final StreamCodec<ByteBuf, CMessagePlayerCapSetPerk> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, msg -> Optional.ofNullable(msg.perk).map(PerkRegistry::getKey).map(ResourceLocation::toString).orElse(""), (StreamCodec)ByteBufCodecs.BYTE, msg -> (byte)(msg.level & 0xFF), (perkString, level) -> new CMessagePlayerCapSetPerk(PerkRegistry.getValue(perkString), level.byteValue()));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    static void handle(CMessagePlayerCapSetPerk msg, IPayloadContext ctx) {
        if (msg.perk != null) {
            ProxyHelper.getClientPlayer().ifPresent(player -> PlayerKnowledgeHandler.setPerk(player, msg.perk, msg.level));
        }
    }
}

