/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.helper.ProxyHelper;

public record CMessageEffectStarted(int entityId, MobEffectInstance effectInstance) implements CustomPacketPayload
{
    static final CustomPacketPayload.Type<CMessageEffectStarted> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"effect"));
    static StreamCodec<ByteBuf, MobEffectInstance> EFFECT_INSTANCE = new StreamCodec<ByteBuf, MobEffectInstance>(){

        public MobEffectInstance decode(ByteBuf buf) {
            @Nullable CompoundTag effectInstanceTag = ((FriendlyByteBuf)buf).readNbt();
            return Optional.ofNullable(effectInstanceTag).map(MobEffectInstance::load).orElse(new MobEffectInstance(MobEffects.SATURATION));
        }

        public void encode(ByteBuf buf, MobEffectInstance effectInstance) {
            ((FriendlyByteBuf)buf).writeNbt(effectInstance.save());
        }
    };
    static final StreamCodec<ByteBuf, CMessageEffectStarted> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, CMessageEffectStarted::entityId, EFFECT_INSTANCE, CMessageEffectStarted::effectInstance, CMessageEffectStarted::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    static void handle(CMessageEffectStarted msg, IPayloadContext ctx) {
        ProxyHelper.getClientWorld().map(level -> level.getEntity(msg.entityId)).filter(LivingEntity.class::isInstance).map(LivingEntity.class::cast).ifPresent(entity -> {
            MobEffectInstance effectInstance = new MobEffectInstance(msg.effectInstance);
            entity.forceAddEffect(effectInstance, null);
        });
    }
}

