/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.NBTStackHelper;

public record CMessageAllCooldowns(ListTag cooldownTagList) implements CustomPacketPayload
{
    static final CustomPacketPayload.Type<CMessageAllCooldowns> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"all_cooldowns"));
    static StreamCodec<ByteBuf, ListTag> COOLDOWN_TYPE = new StreamCodec<ByteBuf, ListTag>(){

        public ListTag decode(ByteBuf buf) {
            return Optional.ofNullable(((FriendlyByteBuf)buf).readNbt()).flatMap(tag -> NBTStackHelper.getListOrEmpty(tag, "tb_cooldowns")).orElse(new ListTag());
        }

        public void encode(ByteBuf buf, ListTag cooldownTagList) {
            CompoundTag compound = new CompoundTag();
            compound.put("tb_cooldowns", (Tag)cooldownTagList);
            ((FriendlyByteBuf)buf).writeNbt((Tag)compound);
        }
    };
    static final StreamCodec<ByteBuf, CMessageAllCooldowns> STREAM_CODEC = StreamCodec.composite(COOLDOWN_TYPE, CMessageAllCooldowns::cooldownTagList, CMessageAllCooldowns::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    static void handle(CMessageAllCooldowns msg, IPayloadContext ctx) {
        CooldownHandler.INSTANCE.updateAllClientCooldowns(msg.cooldownTagList);
    }
}

