/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.mixin;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ovh.corail.tombstone.capability.PlayerAlignmentHandler;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.ProxyHelper;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModPerks;

@Mixin(value={PotionItem.class}, priority=31)
public abstract class PotionItemMixin {
    private float alchemistBonus = 0.0f;
    private boolean isServerPlayer = false;
    private boolean appliedEarthlyGarden = false;

    @Inject(method={"appendHoverText"}, at={@At(value="HEAD")}, cancellable=true)
    private void methodAppendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag, CallbackInfo callbackInfo) {
        PotionContents potionContents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
        if (potionContents != null) {
            ProxyHelper.getClientPlayer().ifPresent(player -> {
                float bonus = 1.0f + (float)EntityHelper.getPerkLevelWithBonus(player, ModPerks.alchemist) * 0.2f;
                potionContents.addPotionTooltip(tooltip::add, (stack.is(Items.LINGERING_POTION) ? 0.25f : 1.0f) * bonus, context.tickRate());
                callbackInfo.cancel();
            });
        }
    }

    @Inject(method={"finishUsingItem"}, at={@At(value="HEAD")})
    private void methodFinishUsingItemHead(ItemStack stack, Level level, LivingEntity entity, CallbackInfoReturnable<ItemStack> callbackInfoReturnable) {
        this.appliedEarthlyGarden = false;
        this.isServerPlayer = EntityHelper.isValidServerPlayer((Entity)entity);
        this.alchemistBonus = this.isServerPlayer ? 1.0f + (float)EntityHelper.getPerkLevelWithBonus((Player)((ServerPlayer)entity), ModPerks.alchemist) * 0.2f : 0.0f;
    }

    @Redirect(method={"finishUsingItem"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/alchemy/PotionContents;forEachEffect(Ljava/util/function/Consumer;)V"), require=1)
    private void applyAlchemistPerk(PotionContents potionContents, Consumer<MobEffectInstance> effectInstanceConsumer) {
        Consumer<MobEffectInstance> alchemyConsumer = effectInstance -> {
            MobEffect effect = (MobEffect)effectInstance.getEffect().value();
            if (this.alchemistBonus > 0.0f && !effect.isInstantenous() && !EffectHelper.isBadEffect(effect)) {
                EffectHelper.modifyEffectDuration(effectInstance, e -> Mth.floor((float)((float)e.getDuration() * this.alchemistBonus)));
            }
            if (this.isServerPlayer && effectInstance.getEffect() == ModEffects.earthly_garden) {
                this.appliedEarthlyGarden = true;
            }
        };
        potionContents.forEachEffect(alchemyConsumer.andThen(effectInstanceConsumer));
    }

    @Inject(method={"finishUsingItem"}, at={@At(value="RETURN")})
    private void methodFinishUsingItemReturn(ItemStack stack, Level level, LivingEntity entity, CallbackInfoReturnable<ItemStack> callbackInfo) {
        if (this.isServerPlayer && this.appliedEarthlyGarden) {
            PlayerAlignmentHandler.rewardAlignment((ServerPlayer)entity, (Integer)ConfigTombstone.alignment.pointsEarthlyGarden.get());
        }
    }
}

