/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ovh.corail.tombstone.capability.SpellCasterHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModEntities;

@Mixin(value={LivingEntityRenderer.class})
public abstract class LivingEntityRendererMixin<T extends LivingEntity, M extends EntityModel<T>>
implements RenderLayerParent<T, M> {
    @Shadow
    M model;
    private T entity;
    private PoseStack poseStack;
    private MultiBufferSource bufferSource;
    private float r;
    private float g;
    private float b;
    private float a;

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void render(T entity, float p_115309_, float p_115310_, PoseStack poseStack, MultiBufferSource bufferSource, int p_115313_, CallbackInfo callbackInfo) {
        this.entity = entity;
        if (entity.getType() == ModEntities.spectral_wolf) {
            this.poseStack = poseStack;
            this.bufferSource = bufferSource;
            this.r = 0.2f;
            this.g = 1.0f;
            this.b = 1.0f;
            this.a = 0.5f;
        } else if (entity.getType() == EntityType.PLAYER && (entity.hasEffect(ModEffects.ghostly_shape) || EffectHelper.isUnstableIntangibilityActive(entity))) {
            this.poseStack = poseStack;
            this.bufferSource = bufferSource;
            this.r = 0.5f;
            this.g = 1.0f;
            this.b = 1.0f;
            this.a = 0.3f;
        }
    }

    @ModifyVariable(method={"render"}, at=@At(value="STORE"), ordinal=0)
    private RenderType renderType(RenderType renderType) {
        if (this.entity != null) {
            M m;
            if (SpellCasterHandler.hasCapability(this.entity) && SpellCasterHandler.isCasting(this.entity) && (m = this.model) instanceof HumanoidModel) {
                HumanoidModel humanoidModel = (HumanoidModel)m;
                humanoidModel.rightArm.z = 0.0f;
                humanoidModel.rightArm.x = -5.0f;
                humanoidModel.leftArm.z = 0.0f;
                humanoidModel.leftArm.x = 5.0f;
                float bob = (float)((LivingEntity)this.entity).tickCount + Minecraft.getInstance().level.tickRateManager().tickrate();
                humanoidModel.rightArm.xRot = Mth.cos((float)(bob * 0.6662f)) * 0.25f;
                humanoidModel.leftArm.xRot = Mth.cos((float)(bob * 0.6662f)) * 0.25f;
                humanoidModel.rightArm.zRot = 2.3561945f;
                humanoidModel.leftArm.zRot = -2.3561945f;
                humanoidModel.rightArm.yRot = 0.0f;
                humanoidModel.leftArm.yRot = 0.0f;
            }
            if (renderType != null && this.poseStack != null) {
                this.model.renderToBuffer(this.poseStack, this.bufferSource.getBuffer(renderType), 0xF000F0, LivingEntityRenderer.getOverlayCoords(this.entity, (float)0.0f), Helper.convertColorToInt(this.a, this.r, this.g, this.b));
                this.poseStack = null;
                this.bufferSource = null;
                this.entity = null;
                return null;
            }
            this.entity = null;
        }
        return renderType;
    }
}

