/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import ovh.corail.tombstone.api.item.IDisableable;
import ovh.corail.tombstone.registry.ModLootFunctions;

public class CheckEnableFunction
extends LootItemConditionalFunction {
    public static final ResourceLocation RL = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"check_enabled");
    public static final MapCodec<CheckEnableFunction> CODEC = RecordCodecBuilder.mapCodec(b -> CheckEnableFunction.commonFields((RecordCodecBuilder.Instance)b).apply((Applicative)b, CheckEnableFunction::new));

    protected CheckEnableFunction(List<LootItemCondition> conditionsIn) {
        super(conditionsIn);
    }

    public LootItemFunctionType<CheckEnableFunction> getType() {
        return ModLootFunctions.CHECK_ENABLED;
    }

    protected ItemStack run(ItemStack stack, LootContext context) {
        IDisableable disableable;
        Item item = stack.getItem();
        return item instanceof IDisableable && !(disableable = (IDisableable)item).isEnabled() ? ItemStack.EMPTY : stack;
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        protected Builder getThis() {
            return this;
        }

        public LootItemFunction build() {
            return new CheckEnableFunction(this.getConditions());
        }
    }
}

