/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import ovh.corail.tombstone.capability.PlayerKnowledgeHandler;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.LootHelper;
import ovh.corail.tombstone.item.ItemSearchable;

public class ItemSeekerRod
extends ItemSearchable {
    public ItemSeekerRod() {
        super("seeker_rod", () -> SharedConfigTombstone.allowed_magic_items.allowSeekerRod.get());
        this.withEffect();
    }

    @Override
    protected void giveReward(ServerPlayer player, BlockPos targetPos) {
        PlayerKnowledgeHandler.rewardKnowledge(player, 3);
        player.giveExperiencePoints(300);
        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)LootHelper.getSeekerRodReward(player.serverLevel(), targetPos, (Player)player));
        LangKey.MESSAGE_SEEKER_ROD.sendMessage((Player)player, new Object[0]);
        player.level().playSound(null, targetPos, SoundEvents.BELL_RESONATE, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    @Override
    protected BlockEntityType<? extends BlockEntity> getTargetType() {
        return BlockEntityType.BELL;
    }

    @Override
    protected String getMessageToDisplay(Player player, ItemStack stack) {
        if (this.isInVillageRange(player, stack)) {
            if (this.isTargetFound(stack)) {
                return LangKey.MESSAGE_USE_SEEKER_ROD.getText(new Object[0]).getString();
            }
            return LangKey.MESSAGE_FIND_BELL.getText(new Object[0]).getString();
        }
        return LangKey.MESSAGE_FOLLOW_PARTICLES.getText(new Object[0]).getString();
    }
}

