/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.IModInfo;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.api.item.ISoulConsumer;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.ProxyHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemScroll;
import ovh.corail.tombstone.item.ItemScrollBuff;
import ovh.corail.tombstone.loot.IDelayedNBTLoot;
import ovh.corail.tombstone.registry.ModDataComponents;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemMagicScroll
extends ItemScroll
implements IDelayedNBTLoot {
    public ItemMagicScroll() {
        super("magic_scroll", ItemMagicScroll.getBuilder().stacksTo(64).component(ModDataComponents.ENCHANTED, (Object)true), () -> SharedConfigTombstone.allowed_magic_items.allowMagicScroll.get());
    }

    @Override
    public Component getName(ItemStack stack) {
        return this.getMagicEffectName(stack).map(effectName -> Component.translatable((String)("tombstone.item." + (this.isAncient(stack) ? "ancient_" : "enchanted_") + "scroll_of"), (Object[])new Object[]{effectName}).setStyle(StyleType.MESSAGE_SPECIAL)).orElse(super.getName(stack));
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, Item.TooltipContext context, List<Component> tooltip) {
        this.getMagicEffect(stack).ifPresent(effect -> {
            this.addEffectInfo(tooltip, (MobEffect)effect);
            tooltip.add((Component)(this.isAncient(stack) ? LangKey.MESSAGE_AREA_BUFF : LangKey.MESSAGE_USEABLE_ON_ALLY).getText(new Object[0]).withStyle(StyleType.EFFECT_DESCRIPTION));
            this.addItemUse(tooltip, LangKey.ITEM_SCROLL_BUFF_USE2, new Object[0]);
            Optional.ofNullable((String)stack.get(ModDataComponents.EFFECT_ID)).map(ResourceLocation::parse).map(ResourceLocation::getNamespace).flatMap(modid -> ModList.get().getModContainerById(modid).map(ModContainer::getModInfo).map(IModInfo::getDisplayName)).ifPresent(modName -> tooltip.add((Component)Component.literal((String)"[effect added by %s]".formatted(modName)).withStyle(StyleType.EFFECT_DESCRIPTION)));
            if (!effect.isInstantenous()) {
                ProxyHelper.getClientPlayer().ifPresent(player -> tooltip.add((Component)Component.literal((String)("(" + StringUtil.formatTickDuration((int)Mth.floor((float)((float)((Integer)SharedConfigTombstone.magic_item.scrollDuration.get()).intValue() * (1.0f + (float)EntityHelper.getPerkLevelWithBonus(player, ModPerks.rune_inscriber) * 0.1f))), (float)context.tickRate()) + ")")).setStyle(StyleType.MESSAGE_SPELL)));
            }
        });
        super.addTooltipInfo(stack, context, tooltip);
    }

    @Override
    public void fillItemCategory(CreativeModeTab.Output toAdd) {
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!level.isClientSide() && stack.is((Item)this) && TimeHelper.atInterval(entity, TimeHelper.tickFromMinute(1)) && this.getMagicEffect(stack).isEmpty()) {
            this.setRandomMagicEffect(stack);
        }
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return (Boolean)stack.getOrDefault(ModDataComponents.ENCHANTED, (Object)false);
    }

    @Override
    public boolean canEnchant(Level level, BlockPos gravePos, Player player, ItemStack stack) {
        return (Boolean)stack.getOrDefault(ModDataComponents.ENCHANTED, (Object)false);
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        return ISoulConsumer.ConsumeResult.fail();
    }

    @Override
    protected boolean doEffects(ServerLevel level, ServerPlayer player, ItemStack stack, @Nullable LivingEntity target) {
        @Nullable MobEffectInstance effectInstance = this.getMagicEffectInstance(stack).orElse(null);
        if (effectInstance == null) {
            return false;
        }
        MutableComponent effectName = ((MobEffect)effectInstance.getEffect().value()).getDisplayName().plainCopy().setStyle(StyleType.MESSAGE_SPECIAL);
        effectInstance.duration = Mth.floor((float)((float)effectInstance.duration * (1.0f + (float)EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.rune_inscriber) * 0.1f)));
        if (this.isAncient(stack)) {
            List<LivingEntity> allies = level.getEntities((Entity)player, player.getBoundingBox().inflate(3.0, 0.0, 3.0), e -> e != null && e.isAlive()).stream().filter(LivingEntity.class::isInstance).map(LivingEntity.class::cast).filter(e -> this.isTargetForCasting((Player)player, (LivingEntity)e)).toList();
            allies.forEach(arg_0 -> ItemMagicScroll.lambda$doEffects$7(effectInstance, (Component)effectName, arg_0));
            ModTriggers.cast_on_ally.trigger(player, allies.size());
            EffectHelper.addEffect((LivingEntity)player, new MobEffectInstance(effectInstance));
            LangKey.MESSAGE_SPELL_CAST_AROUND.sendMessage((Player)player, StyleType.MESSAGE_SPELL, new Object[]{effectName});
        } else {
            if (target == null) {
                target = player;
            }
            EffectHelper.addEffect(target, new MobEffectInstance(effectInstance));
            if (EntityHelper.isValidServerPlayer((Entity)target)) {
                LangKey.MESSAGE_SPELL_CAST_ON_YOU.sendMessage((Player)((ServerPlayer)target), StyleType.MESSAGE_SPELL, new Object[]{effectName});
            }
            if (!target.equals((Object)player)) {
                ModTriggers.cast_on_ally.trigger(player);
                LangKey.MESSAGE_SPELL_CAST_ON_TARGET.sendMessage((Player)player, StyleType.MESSAGE_SPELL, new Object[]{effectName, target.getName().plainCopy().setStyle(StyleType.TOOLTIP_ITEM)});
            }
        }
        return true;
    }

    public Optional<Component> getMagicEffectName(ItemStack stack) {
        int amplifier = this.getAmplifier(stack);
        return this.getMagicEffect(stack).map(effect -> amplifier > 0 ? effect.getDisplayName().copy().append(" " + EffectHelper.getPotency(amplifier + 1)) : effect.getDisplayName());
    }

    public Optional<MobEffectInstance> getMagicEffectInstance(ItemStack stack) {
        return Optional.ofNullable((String)stack.get(ModDataComponents.EFFECT_ID)).flatMap(id -> BuiltInRegistries.MOB_EFFECT.getHolder(ResourceLocation.parse((String)id))).map(effectHolder -> new MobEffectInstance((Holder)effectHolder, ((MobEffect)effectHolder.value()).isInstantenous() ? 1 : (Integer)SharedConfigTombstone.magic_item.scrollDuration.get(), this.getAmplifier(stack)));
    }

    private Optional<MobEffect> getMagicEffect(ItemStack stack) {
        return Optional.ofNullable((String)stack.get(ModDataComponents.EFFECT_ID)).map(id -> (MobEffect)BuiltInRegistries.MOB_EFFECT.get(ResourceLocation.parse((String)id)));
    }

    private int getAmplifier(ItemStack stack) {
        return Math.min((Integer)SharedConfigTombstone.magic_item.levelMaxMagicScrolls.get(), (Short)stack.getOrDefault(ModDataComponents.EFFECT_AMPLIFIER, (Object)0) & 0xFF);
    }

    public boolean isAllowedEffect(Map.Entry<ResourceKey<MobEffect>, MobEffect> entry) {
        if (entry.getValue() == ModEffects.restoration) {
            return false;
        }
        String namespace = entry.getKey().location().getNamespace();
        String path = entry.getKey().location().getPath();
        return EffectHelper.isBeneficial(entry.getValue()) && !Helper.containRL((List)ConfigTombstone.general.unhandledBeneficialEffects.get(), namespace, path) && (!"tombstone".equals(namespace) || Arrays.stream(ItemScrollBuff.SpellBuff.values()).noneMatch(buff -> buff.getName().equals(path)));
    }

    public ItemStack setRandomMagicEffect(ItemStack stack) {
        return Helper.getRandomInList(BuiltInRegistries.MOB_EFFECT.entrySet().stream().filter(this::isAllowedEffect).map(Map.Entry::getValue).toList()).map(effect -> this.setMagicEffect(stack, (MobEffect)effect, Mth.floor((float)((float)((Integer)SharedConfigTombstone.magic_item.levelMaxMagicScrolls.get()).intValue() * TimeHelper.rise(Helper.RANDOM.nextInt(100), 99))))).orElse(stack);
    }

    public ItemStack setMagicEffect(ItemStack stack, @Nullable MobEffect effect, int amplifier) {
        if (stack.is((Item)this) && effect != null) {
            Optional.ofNullable(BuiltInRegistries.MOB_EFFECT.getKey((Object)effect)).ifPresent(rl -> {
                stack.set(ModDataComponents.EFFECT_ID, (Object)rl.toString());
                stack.set(ModDataComponents.EFFECT_AMPLIFIER, (Object)((short)(amplifier & 0xFF)));
                stack.set(ModDataComponents.ENCHANTED, (Object)true);
            });
        }
        return stack;
    }

    public int getColor(ItemStack stack, int tint) {
        MobEffect effect;
        if ((tint == 1 || tint == 2) && stack.has(ModDataComponents.EFFECT_ID) && (effect = (MobEffect)Optional.ofNullable((String)stack.get(ModDataComponents.EFFECT_ID)).map(id -> (MobEffect)BuiltInRegistries.MOB_EFFECT.get(ResourceLocation.parse((String)id))).orElse(null)) != null) {
            if (tint == 2) {
                return 0xFF000000 | effect.getColor();
            }
            float[] colors = Helper.getRGBColor3F(effect.getColor());
            return 0xFF000000 | Math.round((1.0f - colors[0]) * 255.0f) << 16 | Math.round((1.0f - colors[1]) * 255.0f) << 8 | Math.round((1.0f - colors[2]) * 255.0f);
        }
        return -1;
    }

    @Override
    protected boolean canAffectTarget(ItemStack stack, LivingEntity target) {
        return !this.isAncient(stack) && this.getMagicEffectInstance(stack).map(e -> (!EntityHelper.isUndead(target) || e.getEffect() != MobEffects.HEAL) && target.canBeAffected(e)).orElse(false) != false;
    }

    @Override
    public ItemStack onDelayedLoot(ItemStack stack, LootContext context) {
        return this.setRandomMagicEffect(stack);
    }

    public ItemStack createAncient() {
        ItemStack stack = this.setRandomMagicEffect(new ItemStack((ItemLike)this));
        stack.set(ModDataComponents.ANCIENT, (Object)true);
        return stack;
    }

    private static /* synthetic */ void lambda$doEffects$7(MobEffectInstance effectInstance, Component effectName, LivingEntity e) {
        EffectHelper.addEffect(e, new MobEffectInstance(effectInstance));
        if (EntityHelper.isValidServerPlayer((Entity)e)) {
            LangKey.MESSAGE_SPELL_CAST_ON_YOU.sendMessage((Player)((ServerPlayer)e), StyleType.MESSAGE_SPELL, new Object[]{effectName});
        }
    }
}

