/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.Tags;
import ovh.corail.tombstone.block.BlockDecorativeGrave;
import ovh.corail.tombstone.blockEntity.BlockEntityDecorativeGrave;
import ovh.corail.tombstone.combine.TooltipEngravable;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemGravePlate
extends ItemGeneric {
    private TooltipComponent tooltip;

    public ItemGravePlate() {
        super("grave_plate", ItemGravePlate.getBuilder().stacksTo(1).fireResistant());
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        Component displayName = super.getName(stack);
        if (EngravableHelper.isEngraved(stack)) {
            displayName = LangKey.MESSAGE_ENGRAVED_ITEM.getText(displayName);
        }
        if (!tooltip.isEmpty()) {
            tooltip.set(0, displayName);
        } else {
            tooltip.add(displayName);
        }
        super.appendHoverText(stack, context, tooltip, flag);
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, Item.TooltipContext context, List<Component> tooltip) {
        String engravedName = EngravableHelper.getEngravedName(stack);
        if (!engravedName.isEmpty()) {
            tooltip.add((Component)LangKey.MESSAGE_ENGRAVED.getText(StyleType.TOOLTIP_DESC, new Object[]{Component.literal((String)("\"" + engravedName + "\"")).setStyle(StyleType.TOOLTIP_ITEM)}));
        }
        super.addTooltipInfo(stack, context, tooltip);
    }

    public Component getHighlightTip(ItemStack stack, Component displayName) {
        displayName = super.getName(stack);
        return EngravableHelper.isEngraved(stack) ? LangKey.MESSAGE_ENGRAVED_ITEM.getText(displayName) : displayName;
    }

    public Component getName(ItemStack stack) {
        return Component.literal((String)EngravableHelper.getEngravedName(stack));
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        if (this.tooltip == null) {
            this.tooltip = new TooltipEngravable((TagKey<Item>)Tags.Items.INGOTS_IRON);
        }
        return EngravableHelper.getEngravedName(stack).isEmpty() ? Optional.of(this.tooltip) : Optional.empty();
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        BlockState state;
        if (EntityHelper.isValidPlayer(context.getPlayer()) && ModBlocks.isDecorativeGrave((state = context.getLevel().getBlockState(context.getClickedPos())).getBlock())) {
            EntityHelper.setGlobalItemCooldown(context.getPlayer(), this, 100);
            String engravedName = EngravableHelper.getEngravedName(stack);
            if (!engravedName.isEmpty()) {
                BlockEntityDecorativeGrave tile;
                if (!context.getLevel().isClientSide() && (tile = (BlockEntityDecorativeGrave)Helper.getDecorativeGrave(context.getLevel(), context.getClickedPos()).orElse(null)) != null) {
                    String ownerName = tile.getOwnerName();
                    boolean wasEngraved = (Boolean)state.getValue((Property)BlockDecorativeGrave.IS_ENGRAVED);
                    BlockState newState = (BlockState)state.setValue((Property)BlockDecorativeGrave.IS_ENGRAVED, (Comparable)Boolean.valueOf(true));
                    if (!wasEngraved) {
                        context.getLevel().setBlock(context.getClickedPos(), newState, 3);
                    } else if (!((Boolean)ConfigTombstone.decorative_grave.canReplaceGravePlate.get()).booleanValue()) {
                        LangKey.MESSAGE_GRAVE_PLATE_REPLACEMENT_NOT_ALLOWED.sendMessage(context.getPlayer(), StyleType.COLOR_OFF, new Object[0]);
                        return InteractionResult.FAIL;
                    }
                    tile.setOwner(context.getPlayer().getGameProfile().getId(), engravedName, TimeHelper.systemTime());
                    tile.setChanged();
                    context.getLevel().sendBlockUpdated(context.getClickedPos(), state, newState, 3);
                    if (ownerName.isEmpty()) {
                        stack.shrink(1);
                    } else {
                        EngravableHelper.setEngravedName(stack, ownerName);
                    }
                    ModTriggers.engrave_decorative_grave.trigger((ServerPlayer)context.getPlayer());
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }
}

