/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.Optional;
import java.util.function.BooleanSupplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModDataComponents;

public class ItemGift
extends ItemGeneric {
    public ItemGift() {
        super("gift", ItemGift.getBuilder().stacksTo(1).fireResistant());
        this.withDefaultInfo();
    }

    protected ItemGift(String name, Item.Properties builder, BooleanSupplier supplierEnabled) {
        super(name, builder, supplierEnabled);
    }

    @Override
    public void fillItemCategory(CreativeModeTab.Output toAdd) {
    }

    public Component getName(ItemStack stack) {
        return super.getName(stack).plainCopy().setStyle(StyleType.MESSAGE_SPECIAL);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack heldStack = player.getItemInHand(hand);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.BARREL_OPEN, SoundSource.NEUTRAL, 0.5f, Helper.RANDOM.nextFloat() * 0.1f + 0.9f);
        if (heldStack.is((Item)this) && EntityHelper.isValidPlayer(player)) {
            if (!player.level().isClientSide()) {
                this.giveReward((ServerPlayer)player, heldStack);
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            heldStack.shrink(1);
            return InteractionResultHolder.sidedSuccess((Object)heldStack, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.pass((Object)heldStack);
    }

    protected void giveReward(ServerPlayer player, ItemStack heldStack) {
        CompoundTag compoundTag = ModDataComponents.getCompoundTag(heldStack);
        NBTStackHelper.getListOrEmpty(compoundTag, "Items").ifPresent(list -> list.forEach(tag -> ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)ItemStack.parse((HolderLookup.Provider)player.level().registryAccess(), (Tag)tag).orElse(ItemStack.EMPTY))));
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        return InteractionResult.PASS;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        return Optional.ofNullable(context.getPlayer()).map(player -> this.use(context.getLevel(), (Player)player, context.getHand()).getResult()).orElse(InteractionResult.FAIL);
    }
}

