/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import ovh.corail.tombstone.api.item.ISoulConsumer;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.item.ItemBook;
import ovh.corail.tombstone.item.ItemScroll;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemBookOfScribe
extends ItemBook {
    public ItemBookOfScribe() {
        super("book_of_scribe", () -> SharedConfigTombstone.allowed_magic_items.allowBookOfScribe.get());
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        ItemStack mainhand = player.getMainHandItem();
        if (stack.getItem() != this || mainhand.getItem() == ModItems.scroll_of_knowledge || !(mainhand.getItem() instanceof ItemScroll)) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_SCRIBE_FAILED.getText(new Object[0]));
        }
        ItemStack toGive = mainhand.copy();
        stack.shrink(1);
        mainhand.setCount(soulStrength > 1 ? 5 : 2);
        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)toGive);
        ModTriggers.use_scribe.trigger(player);
        return ISoulConsumer.ConsumeResult.success((Component)LangKey.MESSAGE_SCRIBE_SUCCESS.getText(new Object[0]), soulStrength);
    }
}

