/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.combine.CombineCraft;
import ovh.corail.tombstone.combine.CombineRecipe;
import ovh.corail.tombstone.combine.TooltipCombineCraft;

public interface ICombineCraft {
    public static final Map<Item, List<CombineCraft>> COMBINATION_MAP = new ConcurrentHashMap<Item, List<CombineCraft>>();

    default public Item asSelf() {
        return (Item)this;
    }

    default public List<CombineCraft> getCombinations() {
        return COMBINATION_MAP.computeIfAbsent(this.asSelf(), item -> {
            ArrayList<CombineCraft> list = new ArrayList<CombineCraft>();
            this.addCombinations(list);
            return list;
        });
    }

    public void addCombinations(List<CombineCraft> var1);

    default public TooltipComponent createTooltip() {
        return new TooltipCombineCraft(new ItemStack((ItemLike)this.asSelf()), this.getCombinations().toArray(new CombineCraft[0]));
    }

    @Nullable
    default public CombineCraft getCombination(ItemStack added) {
        return this.getCombinations().stream().filter(c -> c.isIngredient(added)).findFirst().orElse(null);
    }

    @Nullable
    default public CombineCraft fromResult(Item result) {
        return this.getCombinations().stream().filter(c -> c.result().is(result)).findFirst().orElse(null);
    }

    default public List<CombineRecipe> getCombineRecipes() {
        return this.getCombinations().stream().map(c -> new CombineRecipe(Ingredient.of((ItemLike[])new ItemLike[]{this.asSelf()}), c.ingredient(), () -> c.isEnabled() ? c.result() : ItemStack.EMPTY)).collect(Collectors.toList());
    }
}

