/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.VanillaStructures;

public class WorldHelper {
    private static final Map<String, Component> BIOME_NAMES = new ConcurrentHashMap<String, Component>();
    private static final Map<String, Component> STRUCTURE_NAMES = new ConcurrentHashMap<String, Component>();
    private static final Map<ResourceKey<Level>, Object2BooleanMap<ResourceLocation>> STRUCTURES_BY_WORLD = new ConcurrentHashMap<ResourceKey<Level>, Object2BooleanMap<ResourceLocation>>();

    public static Component getBiomeName(String id) {
        return WorldHelper.getName(id, true);
    }

    public static Component getStructureName(String id) {
        return WorldHelper.getName(id, false);
    }

    private static Component getName(String id, boolean isBiome) {
        return (isBiome ? BIOME_NAMES : STRUCTURE_NAMES).computeIfAbsent(id, k -> {
            String[] splits = id.toLowerCase(Locale.US).split(":");
            MutableComponent structureName = Component.literal((String)Helper.capitalizeWord(splits[splits.length - 1].replace("_", " ")));
            return structureName.append(" [").append(splits.length < 2 ? "Minecraft" : Helper.capitalizeWord(splits[0].replace("_", " "))).append("]");
        });
    }

    public static Location findNearestBiome(ServerLevel level, BlockPos pos, Predicate<Holder<Biome>> predic) {
        BlockPos startingPos = new BlockPos(pos.getX(), WorldHelper.getHeightmapY(level, Heightmap.Types.WORLD_SURFACE, pos.getX(), pos.getZ()), pos.getZ());
        for (int nbTry = 0; nbTry < 3; ++nbTry) {
            Pair result = level.findClosestBiome3d(predic, startingPos = WorldHelper.getCloserValidPos((Level)level, startingPos.offset((int)((double)nbTry * Helper.RANDOM.nextGaussian() * 5000.0), 0, (int)((double)nbTry * Helper.RANDOM.nextGaussian() * 5000.0))), 6400, 32, 64);
            if (result == null || !WorldHelper.isValidPos((Level)level, (BlockPos)result.getFirst())) continue;
            return new Location((BlockPos)result.getFirst(), (Level)level);
        }
        return Location.ORIGIN;
    }

    public static org.apache.commons.lang3.tuple.Pair<Location, ResourceLocation> findNearestStructure(ServerLevel level, BlockPos pos, TagKey<Structure> tagKey, boolean unexplored) {
        return WorldHelper.asHolderSet(level, tagKey).map(holders -> WorldHelper.findNearestStructure(level, pos, (HolderSet<Structure>)holders, unexplored)).orElseGet(() -> org.apache.commons.lang3.tuple.Pair.of((Object)Location.ORIGIN, null));
    }

    public static org.apache.commons.lang3.tuple.Pair<Location, ResourceLocation> findNearestStructure(ServerLevel level, BlockPos pos, HolderSet<Structure> holderset, boolean unexplored) {
        if (level.getServer().getWorldData().worldGenOptions().generateStructures()) {
            Optional<ResourceLocation> optionalRL;
            BlockPos startingPos = WorldHelper.getCloserValidPos((Level)level, pos);
            Pair res = level.getChunkSource().getGenerator().findNearestMapStructure(level, holderset, startingPos, 100, unexplored);
            if (res != null && WorldHelper.isValidPos((Level)level, (BlockPos)res.getFirst()) && (optionalRL = ((Holder)res.getSecond()).unwrapKey().map(ResourceKey::location)).isPresent()) {
                return org.apache.commons.lang3.tuple.Pair.of((Object)new Location(((BlockPos)res.getFirst()).getX(), WorldHelper.getY(optionalRL.get(), level, pos.getX(), pos.getZ()), ((BlockPos)res.getFirst()).getZ(), (Level)level), (Object)optionalRL.get());
            }
        }
        return org.apache.commons.lang3.tuple.Pair.of((Object)Location.ORIGIN, null);
    }

    public static Location findNearestVillage(ServerLevel level, BlockPos pos) {
        return (Location)WorldHelper.findNearestStructure(level, pos, (TagKey<Structure>)StructureTags.VILLAGE, false).getLeft();
    }

    public static boolean hasStructureInWorld(ServerLevel level, ResourceLocation structureRL, HolderSet<Biome> structureBiomes) {
        return STRUCTURES_BY_WORLD.computeIfAbsent((ResourceKey<Level>)level.dimension(), levelKey -> new Object2BooleanOpenHashMap()).computeIfAbsent((Object)structureRL, rl -> {
            Set possibleBiomes = level.getChunkSource().getGenerator().getBiomeSource().possibleBiomes();
            return structureBiomes.stream().anyMatch(possibleBiomes::contains);
        });
    }

    @Nullable
    public static HolderSet<Structure> getRandomStructure(ServerLevel level, Predicate<ResourceLocation> predic) {
        ResourceLocation structureRL = Helper.getRandomInList(level.registryAccess().registryOrThrow(Registries.STRUCTURE).keySet().stream().filter(predic).collect(Collectors.toList())).orElse(null);
        if (structureRL != null) {
            VanillaStructures vanillaStructure;
            if ("minecraft".equals(structureRL.getNamespace()) && (vanillaStructure = VanillaStructures.getStructure(structureRL)) != null) {
                return vanillaStructure.asHolderSet(level);
            }
            return WorldHelper.asHolderSet(level, structureRL);
        }
        return null;
    }

    public static int getY(ResourceLocation structureRL, ServerLevel serverLevel, int x, int z) {
        return Optional.ofNullable(VanillaStructures.getStructure(structureRL)).map(vanillaStructure -> switch (vanillaStructure) {
            default -> throw new MatchException(null, null);
            case VanillaStructures.RUINED_PORTAL -> 70;
            case VanillaStructures.NETHER_FOSSIL -> 65;
            case VanillaStructures.FORTRESS, VanillaStructures.END_CITY -> 60;
            case VanillaStructures.MINESHAFT -> 40;
            case VanillaStructures.BASTION_REMNANT -> 35;
            case VanillaStructures.STRONGHOLD -> 0;
            case VanillaStructures.ANCIENT_CITY, VanillaStructures.TRIAL_CHAMBERS -> -30;
            case VanillaStructures.SHIPWRECK -> WorldHelper.getHeightmapY(serverLevel, structureRL.getPath().contains("beached") ? Heightmap.Types.WORLD_SURFACE : Heightmap.Types.OCEAN_FLOOR, x, z);
            case VanillaStructures.MONUMENT, VanillaStructures.OCEAN_RUIN -> WorldHelper.getHeightmapY(serverLevel, Heightmap.Types.OCEAN_FLOOR, x, z);
            case VanillaStructures.VILLAGE, VanillaStructures.PILLAGER_OUTPOST, VanillaStructures.DESERT_PYRAMID, VanillaStructures.JUNGLE_TEMPLE, VanillaStructures.IGLOO, VanillaStructures.MANSION, VanillaStructures.SWAMP_HUT, VanillaStructures.BURIED_TREASURE, VanillaStructures.TRAIL_RUINS -> WorldHelper.getHeightmapY(serverLevel, Heightmap.Types.WORLD_SURFACE, x, z);
        }).orElseGet(() -> {
            if (structureRL.getNamespace().equals("tombstone") && structureRL.getPath().equals("abandoned_grave_ocean")) {
                return WorldHelper.getHeightmapY(serverLevel, Heightmap.Types.OCEAN_FLOOR, x, z);
            }
            return WorldHelper.getHeightmapY(serverLevel, Heightmap.Types.WORLD_SURFACE, x, z);
        });
    }

    public static Optional<HolderSet.Named<Structure>> asHolderSet(ServerLevel level, TagKey<Structure> tagKey) {
        return level.registryAccess().lookupOrThrow(Registries.STRUCTURE).get(tagKey);
    }

    @Nullable
    public static HolderSet<Structure> asHolderSet(ServerLevel level, ResourceLocation resourceLocation) {
        return WorldHelper.asHolderSet(level, (ResourceKey<Structure>)ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)resourceLocation));
    }

    @Nullable
    public static HolderSet<Structure> asHolderSet(ServerLevel level, ResourceKey<Structure> resourceKey) {
        return level.registryAccess().lookupOrThrow(Registries.STRUCTURE).get(resourceKey).map(xva$0 -> HolderSet.direct((Holder[])new Holder[]{xva$0})).orElse(null);
    }

    public static int getHeightmapY(ServerLevel serverLevel, Heightmap.Types heightmapType, int x, int z) {
        serverLevel.getBlockState(new BlockPos(x, 75, z));
        return serverLevel.getHeight(heightmapType, x, z);
    }

    public static BlockPos getCloserValidPos(Level level, BlockPos pos) {
        boolean validY;
        WorldBorder border = level.getWorldBorder();
        boolean validXZ = border.isWithinBounds(pos);
        boolean bl = validY = !level.isOutsideBuildHeight(pos);
        if (validXZ && validY) {
            return pos;
        }
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        if (!validXZ) {
            x = Math.min(Math.max(pos.getX(), (int)border.getMinX()), (int)border.getMaxX());
            z = Math.min(Math.max(pos.getZ(), (int)border.getMinZ()), (int)border.getMaxZ());
        }
        if (!validY) {
            y = Mth.clamp((int)pos.getY(), (int)level.getMinBuildHeight(), (int)(level.getMinBuildHeight() + level.dimensionType().logicalHeight()));
        }
        return new BlockPos(x, y, z);
    }

    public static boolean isValidPos(@Nullable Level level, BlockPos pos) {
        return level != null && level.getWorldBorder().isWithinBounds(pos) && !WorldHelper.isOutsideBuildHeight(level, pos);
    }

    public static boolean isOutsideWorldBorders(Level level, BlockPos pos) {
        return !level.getWorldBorder().isWithinBounds(pos);
    }

    public static boolean isOutsideBuildHeight(Level level, BlockPos pos) {
        return level.isOutsideBuildHeight(pos);
    }

    public static void clear() {
        BIOME_NAMES.clear();
        STRUCTURE_NAMES.clear();
        STRUCTURES_BY_WORLD.clear();
    }
}

