/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.WorldHelper;

public final class VanillaStructures
extends Enum<VanillaStructures> {
    public static final /* enum */ VanillaStructures VILLAGE = new VanillaStructures("village", (TagKey<Structure>)StructureTags.VILLAGE);
    public static final /* enum */ VanillaStructures DESERT_PYRAMID = new VanillaStructures("desert_pyramid", (ResourceKey<Structure>)BuiltinStructures.DESERT_PYRAMID);
    public static final /* enum */ VanillaStructures IGLOO = new VanillaStructures("igloo", (ResourceKey<Structure>)BuiltinStructures.IGLOO);
    public static final /* enum */ VanillaStructures JUNGLE_TEMPLE = new VanillaStructures("jungle_pyramid", (ResourceKey<Structure>)BuiltinStructures.JUNGLE_TEMPLE);
    public static final /* enum */ VanillaStructures MANSION = new VanillaStructures("mansion", (ResourceKey<Structure>)BuiltinStructures.WOODLAND_MANSION);
    public static final /* enum */ VanillaStructures MONUMENT = new VanillaStructures("monument", (ResourceKey<Structure>)BuiltinStructures.OCEAN_MONUMENT);
    public static final /* enum */ VanillaStructures STRONGHOLD = new VanillaStructures("stronghold", (ResourceKey<Structure>)BuiltinStructures.STRONGHOLD);
    public static final /* enum */ VanillaStructures END_CITY = new VanillaStructures("end_city", (ResourceKey<Structure>)BuiltinStructures.END_CITY);
    public static final /* enum */ VanillaStructures MINESHAFT = new VanillaStructures("mineshaft", (TagKey<Structure>)StructureTags.MINESHAFT);
    public static final /* enum */ VanillaStructures FORTRESS = new VanillaStructures("fortress", (ResourceKey<Structure>)BuiltinStructures.FORTRESS);
    public static final /* enum */ VanillaStructures SWAMP_HUT = new VanillaStructures("swamp_hut", (ResourceKey<Structure>)BuiltinStructures.SWAMP_HUT);
    public static final /* enum */ VanillaStructures OCEAN_RUIN = new VanillaStructures("ocean_ruin", (TagKey<Structure>)StructureTags.OCEAN_RUIN);
    public static final /* enum */ VanillaStructures BURIED_TREASURE = new VanillaStructures("buried_treasure", (ResourceKey<Structure>)BuiltinStructures.BURIED_TREASURE);
    public static final /* enum */ VanillaStructures SHIPWRECK = new VanillaStructures("shipwreck", (TagKey<Structure>)StructureTags.SHIPWRECK);
    public static final /* enum */ VanillaStructures PILLAGER_OUTPOST = new VanillaStructures("pillager_outpost", (ResourceKey<Structure>)BuiltinStructures.PILLAGER_OUTPOST);
    public static final /* enum */ VanillaStructures RUINED_PORTAL = new VanillaStructures("ruined_portal", (TagKey<Structure>)StructureTags.RUINED_PORTAL);
    public static final /* enum */ VanillaStructures NETHER_FOSSIL = new VanillaStructures("nether_fossil", (ResourceKey<Structure>)BuiltinStructures.NETHER_FOSSIL);
    public static final /* enum */ VanillaStructures BASTION_REMNANT = new VanillaStructures("bastion_remnant", (ResourceKey<Structure>)BuiltinStructures.BASTION_REMNANT);
    public static final /* enum */ VanillaStructures ANCIENT_CITY = new VanillaStructures("ancient_city", (ResourceKey<Structure>)BuiltinStructures.ANCIENT_CITY);
    public static final /* enum */ VanillaStructures TRAIL_RUINS = new VanillaStructures("trail_ruins", (ResourceKey<Structure>)BuiltinStructures.TRAIL_RUINS);
    public static final /* enum */ VanillaStructures TRIAL_CHAMBERS = new VanillaStructures("trial_chambers", (ResourceKey<Structure>)BuiltinStructures.TRIAL_CHAMBERS);
    private final String identifier;
    @Nullable
    private TagKey<Structure> tagKey = null;
    @Nullable
    private ResourceKey<Structure> resourceKey = null;
    private static final /* synthetic */ VanillaStructures[] $VALUES;

    public static VanillaStructures[] values() {
        return (VanillaStructures[])$VALUES.clone();
    }

    public static VanillaStructures valueOf(String name) {
        return Enum.valueOf(VanillaStructures.class, name);
    }

    private VanillaStructures(String identifier, ResourceKey<Structure> resourceKey) {
        this.identifier = identifier;
        this.resourceKey = resourceKey;
    }

    private VanillaStructures(String identifier, TagKey<Structure> tagKey) {
        this.identifier = identifier;
        this.tagKey = tagKey;
    }

    public String getName() {
        return this.identifier;
    }

    public boolean is(ResourceLocation structureId) {
        return "minecraft".equals(structureId.getNamespace()) && structureId.getPath().contains(this.getName());
    }

    public HolderSet<Structure> asHolderSet(ServerLevel level) {
        if (this.tagKey != null) {
            return (HolderSet)WorldHelper.asHolderSet(level, this.tagKey).get();
        }
        assert (this.resourceKey != null);
        return WorldHelper.asHolderSet(level, this.resourceKey);
    }

    @Nullable
    public static VanillaStructures getStructure(ResourceLocation structureRL) {
        return "minecraft".equals(structureRL.getNamespace()) ? (VanillaStructures)Stream.of(VanillaStructures.values()).filter(p -> p.is(structureRL)).findFirst().orElse(null) : null;
    }

    @Nullable
    public static HolderSet<Structure> getRandomStructure(ServerLevel level, Predicate<VanillaStructures> predic) {
        return Helper.getRandomInList(Arrays.stream(VanillaStructures.values()).filter(predic).collect(Collectors.toList())).map(vanillaStructure -> vanillaStructure.asHolderSet(level)).orElse(null);
    }

    private static /* synthetic */ VanillaStructures[] $values() {
        return new VanillaStructures[]{VILLAGE, DESERT_PYRAMID, IGLOO, JUNGLE_TEMPLE, MANSION, MONUMENT, STRONGHOLD, END_CITY, MINESHAFT, FORTRESS, SWAMP_HUT, OCEAN_RUIN, BURIED_TREASURE, SHIPWRECK, PILLAGER_OUTPOST, RUINED_PORTAL, NETHER_FOSSIL, BASTION_REMNANT, ANCIENT_CITY, TRAIL_RUINS, TRIAL_CHAMBERS};
    }

    static {
        $VALUES = VanillaStructures.$values();
    }
}

