/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import ovh.corail.tombstone.helper.Helper;

@OnlyIn(value=Dist.CLIENT)
public class RenderHelper {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"textures/block/circle.png");

    public static void fillGradient(Matrix4f matrix, int left, int top, int right, int bottom, int color1, int color2, int zLevel, boolean isHorizontal) {
        float[] argb1 = Helper.getRGBColor4F(color1);
        float[] argb2 = Helper.getRGBColor4F(color2);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        RenderHelper.makeVertex(matrix, bufferbuilder, right, top, zLevel, isHorizontal ? argb2 : argb1);
        RenderHelper.makeVertex(matrix, bufferbuilder, left, top, zLevel, argb1);
        RenderHelper.makeVertex(matrix, bufferbuilder, left, bottom, zLevel, isHorizontal ? argb1 : argb2);
        RenderHelper.makeVertex(matrix, bufferbuilder, right, bottom, zLevel, argb2);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    private static void makeVertex(Matrix4f matrix, BufferBuilder bufferbuilder, int x, int y, int zLevel, float[] colorArray) {
        bufferbuilder.addVertex(matrix, (float)x, (float)y, (float)zLevel).setColor(colorArray[0], colorArray[1], colorArray[2], colorArray[3]);
    }

    public static void renderCircle(GuiGraphics guiGraphics, int x, int y, int color, int size) {
        RenderHelper.renderCircle(guiGraphics, x, y, color, -5586716, size);
    }

    public static void renderCircle(GuiGraphics guiGraphics, int x, int y, int color, int colorBg, int size) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.fill(x + 1, y + 1, x - 1 + size, y - 1 + size, colorBg);
        float[] colors = Helper.getRGBColor4F(color);
        RenderSystem.setShaderColor((float)colors[0], (float)colors[1], (float)colors[2], (float)colors[3]);
        guiGraphics.blit(TEXTURE, x, y, 0.0f, 0.0f, size, size, size, size);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static enum Sprites {
        ARROW_SPRITE(ResourceLocation.withDefaultNamespace((String)"widget/page_forward_highlighted"), 23, 13),
        MOUSE_ON(ResourceLocation.withDefaultNamespace((String)"toast/right_click"), 20, 20),
        MOUSE_OFF(ResourceLocation.withDefaultNamespace((String)"toast/mouse"), 20, 20),
        BAR_BACKGROUND_SPRITE(ResourceLocation.withDefaultNamespace((String)"boss_bar/yellow_background"), 182, 5),
        BAR_PROGRESS_SPRITE(ResourceLocation.withDefaultNamespace((String)"boss_bar/yellow_progress"), 182, 5),
        BAR_NOTCHED_12_SPRITE(ResourceLocation.withDefaultNamespace((String)"boss_bar/notched_12_background"), 182, 3);

        private final ResourceLocation spriteRL;
        private final int defaultWidth;
        private final int defaultHeight;

        private Sprites(ResourceLocation spriteRL, int defaultWidth, int defaultHeight) {
            this.spriteRL = spriteRL;
            this.defaultWidth = defaultWidth;
            this.defaultHeight = defaultHeight;
        }

        public void render(GuiGraphics guiGraphics, int x, int y) {
            this.render(guiGraphics, x, y, 1.0f);
        }

        public void render(GuiGraphics guiGraphics, int x, int y, float scale) {
            this.render(guiGraphics, x, y, scale, scale);
        }

        public void render(GuiGraphics guiGraphics, int x, int y, float scaleWidth, float scaleHeight) {
            this.render(guiGraphics, x, y, Math.round((float)this.defaultWidth * scaleWidth), Math.round((float)this.defaultHeight * scaleHeight));
        }

        public void render(GuiGraphics guiGraphics, int x, int y, int width, int height) {
            RenderSystem.enableBlend();
            guiGraphics.blitSprite(this.spriteRL, width, height, 0, 0, x, y, width, height);
        }
    }
}

