/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.mojang.authlib.GameProfile;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.commands.CommandSource;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.Tags;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.capability.PlayerAlignmentHandler;
import ovh.corail.tombstone.capability.PlayerKnowledgeHandler;
import ovh.corail.tombstone.capability.ProtectedEntityHandler;
import ovh.corail.tombstone.capability.ServantUndeadHandler;
import ovh.corail.tombstone.compatibility.CompatibilityIceberg;
import ovh.corail.tombstone.compatibility.CompatibilityToughAsNails;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.entity.GraveGuardian;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TamableType;
import ovh.corail.tombstone.network.CMessagePlayerCapSyncAlignment;
import ovh.corail.tombstone.network.CMessagePlayerCapSyncKnowledge;
import ovh.corail.tombstone.network.CMessagePlayerCapSyncPerks;
import ovh.corail.tombstone.network.CMessagePlayerProtection;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.perk.Perk;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModTags;
import ovh.corail.tombstone.registry.ModTriggers;

public final class EntityHelper {
    private static final String TOMBSTONE_PLAYER_TAG = "tb_player_tag";

    public static boolean isValidPlayer(@Nullable CommandSource sender) {
        Player player;
        return sender instanceof Player && !EntityHelper.isFakePlayer(player = (Player)sender);
    }

    public static boolean isValidPlayer(@Nullable Entity entity) {
        Player player;
        return entity instanceof Player && !EntityHelper.isFakePlayer(player = (Player)entity);
    }

    public static boolean isValidPlayer(@Nullable Player player) {
        return player != null && !EntityHelper.isFakePlayer(player);
    }

    public static boolean isValidServerPlayer(@Nullable Entity entity) {
        ServerPlayer serverPlayer;
        return entity instanceof ServerPlayer && !EntityHelper.isFakePlayer((Player)(serverPlayer = (ServerPlayer)entity));
    }

    public static boolean isValidServerPlayer(@Nullable ServerPlayer serverPlayer) {
        return serverPlayer != null && !EntityHelper.isFakePlayer((Player)serverPlayer);
    }

    public static boolean isFakePlayer(Player player) {
        return player.isFakePlayer() || CompatibilityIceberg.instance.isBrokenCode(player);
    }

    public static boolean checkUnconventionalFakePlayer(@Nullable ServerPlayer player) {
        try {
            if (player == null || EntityHelper.isFakePlayer((Player)player) || player.connection.getRemoteAddress() == null) {
                return true;
            }
            ServerPlayer existingPlayer = Optional.ofNullable(Helper.getServer()).map(s -> s.getPlayerList().getPlayer(player.getUUID())).orElse(null);
            return existingPlayer == null || !existingPlayer.position().equals((Object)player.position());
        }
        catch (Throwable t) {
            return true;
        }
    }

    public static boolean isKilledByOtherPlayer(Player player, DamageSource source) {
        return EntityHelper.isValidPlayer(source.getEntity()) && !player.equals((Object)source.getEntity());
    }

    public static void resetNutrition(ServerPlayer player) {
        FoodData foodData = player.getFoodData();
        foodData.setExhaustion(0.0f);
        foodData.setFoodLevel(20);
        if (SupportMods.TAN.isLoaded()) {
            CompatibilityToughAsNails.instance.resetThirst((Player)player);
        }
    }

    public static void setPlayerXp(Player player, int amount) {
        if (amount <= 0) {
            return;
        }
        player.experienceLevel = 0;
        player.totalExperience = 0;
        player.experienceProgress = 0.0f;
        player.experienceProgress += (float)amount / (float)player.getXpNeededForNextLevel();
        player.totalExperience += amount;
        while (player.experienceProgress >= 1.0f) {
            player.experienceProgress = (player.experienceProgress - 1.0f) * (float)player.getXpNeededForNextLevel();
            ++player.experienceLevel;
            player.experienceProgress /= (float)player.getXpNeededForNextLevel();
        }
    }

    public static Pair<Integer, Float> getPlayerXpPair(int experienceTotal) {
        float aExperience;
        if (experienceTotal <= 0) {
            return Pair.of((Object)0, (Object)Float.valueOf(0.0f));
        }
        int aExperienceLevel = 0;
        for (aExperience = (float)experienceTotal / (float)EntityHelper.xpBarCap(aExperienceLevel); aExperience >= 1.0f; aExperience /= (float)EntityHelper.xpBarCap(++aExperienceLevel)) {
            aExperience = (aExperience - 1.0f) * (float)EntityHelper.xpBarCap(aExperienceLevel);
        }
        return Pair.of((Object)aExperienceLevel, (Object)Float.valueOf(aExperience));
    }

    public static int getPlayerTotalXp(Player player) {
        return EntityHelper.getPlayerTotalXp(player.experienceLevel, player.experienceProgress);
    }

    private static int getPlayerTotalXp(int level, float bar) {
        int experienceTotal = level < 17 ? level * (level + 6) : (level < 32 ? level * (5 * level - 81) / 2 + 360 : level * (9 * level - 325) / 2 + 2220);
        return experienceTotal += Mth.floor((float)((float)EntityHelper.xpBarCap(level) * bar));
    }

    private static int xpBarCap(int level) {
        return level >= 30 ? 112 + (level - 30) * 9 : (level >= 15 ? 37 + (level - 15) * 5 : 7 + level * 2);
    }

    public static boolean noGlobalItemCooldown(@Nullable Player player, Item item) {
        return !EntityHelper.hasGlobalItemCooldown(player, item);
    }

    public static boolean noGlobalItemCooldown(@Nullable Player player, ItemStack stack) {
        return EntityHelper.noGlobalItemCooldown(player, stack.getItem());
    }

    public static boolean hasGlobalItemCooldown(@Nullable Player player, Item item) {
        return Optional.ofNullable(player).map(p -> p.getCooldowns().isOnCooldown(item)).orElse(true);
    }

    public static boolean hasGlobalItemCooldown(@Nullable Player player, ItemStack stack) {
        return EntityHelper.hasGlobalItemCooldown(player, stack.getItem());
    }

    public static void setGlobalItemCooldown(Player player, Item item, int ticks) {
        player.getCooldowns().addCooldown(item, ticks);
    }

    public static void setGlobalItemCooldown(Player player, ItemStack stack, int ticks) {
        EntityHelper.setGlobalItemCooldown(player, stack.getItem(), ticks);
    }

    public static void removeGlobalItemCooldown(@Nullable Player player, Item item) {
        Optional.ofNullable(player).ifPresent(p -> player.getCooldowns().removeCooldown(item));
    }

    public static void applyKillResult(DamageSource damageSource, LivingEntity killedEntity) {
        if (EntityHelper.isValidServerPlayer((Entity)killedEntity.lastHurtByPlayer)) {
            ServerPlayer player = (ServerPlayer)killedEntity.lastHurtByPlayer;
            assert (player != null);
            if (player.hasEffect(ModEffects.ghostly_shape) || player.hasEffect(ModEffects.diversion)) {
                killedEntity.setLastHurtByPlayer(null);
                return;
            }
            EntityType entityType = killedEntity.getType();
            if (entityType.is(ModTags.EntityTypes.DECREASE_ALIGNMENT)) {
                PlayerAlignmentHandler.rewardAlignment(player, (Integer)ConfigTombstone.alignment.pointsKillDecreasingAlignment.get());
                if (entityType == EntityType.VILLAGER) {
                    ModTriggers.killed_enough_villager.trigger(player);
                }
            } else if (entityType.is(ModTags.EntityTypes.INCREASE_ALIGNMENT) || entityType == EntityType.ZOMBIE && killedEntity.getPersistentData().getBoolean("siege")) {
                PlayerAlignmentHandler.rewardAlignment(player, (Integer)ConfigTombstone.alignment.pointsKillIncreasingAlignment.get());
                ModTriggers.killed_enough_raider.trigger(player);
            } else if (TamableType.isTamedBy((LivingEntity)player, killedEntity)) {
                PlayerAlignmentHandler.rewardAlignment(player, (Integer)ConfigTombstone.alignment.pointsKillTamedCreature.get());
            }
            if (EntityHelper.isUndead(killedEntity)) {
                ModTriggers.killed_enough_undead.trigger(player);
                if (EntityHelper.isBoss(killedEntity)) {
                    ModTriggers.kill_undead_boss.trigger(player);
                }
            }
        }
    }

    public static boolean isBadAlignment(Player player) {
        return PlayerAlignmentHandler.getAlignmentLevel(player) < 0;
    }

    public static int getPerkLevelWithBonus(@Nullable Player player, @Nullable Perk perk) {
        return player == null ? 0 : PlayerKnowledgeHandler.getPerkLevelWithBonus(player, perk);
    }

    public static void syncProtectedPlayerCapability(ServerPlayer player) {
        if (ProtectedEntityHandler.hasCapability((Entity)player)) {
            PacketHandler.sendToPlayer(new CMessagePlayerProtection(ProtectedEntityHandler.isActive((Entity)player)), player);
        }
    }

    public static void syncPlayerCapability(ServerPlayer player) {
        EntityHelper.syncPlayerCapability(player, false);
    }

    public static void syncPlayerCapability(ServerPlayer player, boolean checked) {
        int knowledge = PlayerKnowledgeHandler.getKnowledge((Player)player);
        int alignment = PlayerAlignmentHandler.getAlignmentValue((Player)player);
        Map<Perk, Integer> perks = PlayerKnowledgeHandler.getPerks((Player)player);
        if (checked) {
            int totalPerkPoints = PlayerKnowledgeHandler.getTotalPerkPoints((Player)player);
            boolean valid = true;
            Iterator<Map.Entry<Perk, Integer>> it = perks.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Perk, Integer> entry = it.next();
                if (!valid || Helper.isDisabledPerk(entry.getKey(), (Player)player)) {
                    it.remove();
                    continue;
                }
                int maxPerkLevel = Math.min(totalPerkPoints, entry.getKey().getLevelMax());
                if (entry.getValue() > maxPerkLevel) {
                    entry.setValue(maxPerkLevel);
                }
                for (int i = 1; i <= entry.getValue() && valid; ++i) {
                    int cost = entry.getKey().getCost(i);
                    if (cost <= totalPerkPoints) {
                        totalPerkPoints -= cost;
                        continue;
                    }
                    valid = false;
                    if (i > 1) {
                        entry.setValue(i - 1);
                        continue;
                    }
                    it.remove();
                }
            }
        }
        PacketHandler.sendToPlayer(new CMessagePlayerCapSyncKnowledge(knowledge), player);
        PacketHandler.sendToPlayer(new CMessagePlayerCapSyncAlignment(alignment), player);
        PacketHandler.sendToPlayer(new CMessagePlayerCapSyncPerks(perks), player);
    }

    public static CompoundTag getPersistentTag(Player player) {
        CompoundTag persistantData = player.getPersistentData();
        if (persistantData.contains("PlayerPersisted", 10)) {
            return persistantData.getCompound("PlayerPersisted");
        }
        CompoundTag persistantTag = new CompoundTag();
        persistantData.put("PlayerPersisted", (Tag)persistantTag);
        return persistantTag;
    }

    public static CompoundTag getTombstoneTag(Player player) {
        CompoundTag persistentTag = EntityHelper.getPersistentTag(player);
        if (persistentTag.contains(TOMBSTONE_PLAYER_TAG, 10)) {
            return persistentTag.getCompound(TOMBSTONE_PLAYER_TAG);
        }
        CompoundTag tombstonePlayerTag = new CompoundTag();
        persistentTag.put(TOMBSTONE_PLAYER_TAG, (Tag)tombstonePlayerTag);
        return tombstonePlayerTag;
    }

    public static void writePlayerData(MinecraftServer server, Player player) {
        server.getPlayerList().playerIo.save(player);
    }

    public static void loadPlayerData(MinecraftServer server, Player player) {
        server.getPlayerList().playerIo.load(player);
    }

    @Nullable
    public static ServerPlayer getOfflinePlayer(MinecraftServer server, UUID id) {
        GameProfile profil = EntityHelper.getGameProfile(server, id);
        if (profil != null) {
            ServerPlayer player = EntityHelper.getPlayerForLogin(server, profil);
            EntityHelper.loadPlayerData(server, (Player)player);
            return player;
        }
        return null;
    }

    @Nullable
    public static ServerPlayer getOfflinePlayer(MinecraftServer server, String playerName) {
        GameProfile profil = EntityHelper.getGameProfile(server, playerName);
        if (profil != null) {
            ServerPlayer player = EntityHelper.getPlayerForLogin(server, profil);
            EntityHelper.loadPlayerData(server, (Player)player);
            return player;
        }
        return null;
    }

    @Nullable
    public static GameProfile getGameProfile(MinecraftServer server, UUID id) {
        return server.getProfileCache().get(id).orElse(null);
    }

    @Nullable
    public static GameProfile getGameProfile(MinecraftServer server, String playerName) {
        GameProfileCache.GameProfileInfo entry = (GameProfileCache.GameProfileInfo)server.getProfileCache().profilesByName.get(playerName.toLowerCase(Locale.US));
        if (entry != null) {
            return entry.getProfile();
        }
        return null;
    }

    public static ServerPlayer getPlayerForLogin(MinecraftServer server, GameProfile profil) {
        return server.getPlayerList().getPlayerForLogin(profil, ClientInformation.createDefault());
    }

    public static boolean isUndead(LivingEntity entity) {
        return entity.getType().is(EntityTypeTags.UNDEAD);
    }

    public static boolean isBoss(LivingEntity entity) {
        return entity.getType().is(Tags.EntityTypes.BOSSES);
    }

    public static boolean targetAnEnemy(LivingEntity entity) {
        Mob mob;
        return entity instanceof Mob && EntityHelper.isEnemy((Entity)(mob = (Mob)entity).getTarget());
    }

    public static void resetAttackAction(LivingEntity entity) {
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.goalSelector.getAvailableGoals().stream().filter(WrappedGoal::isRunning).forEach(WrappedGoal::stop);
            mob.targetSelector.getAvailableGoals().stream().filter(WrappedGoal::isRunning).forEach(WrappedGoal::stop);
            mob.getNavigation().stop();
            mob.target = null;
        }
        entity.setLastHurtByMob(null);
        entity.setLastHurtByPlayer(null);
        entity.setLastHurtMob(null);
        if (entity.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET)) {
            entity.getBrain().setMemory(MemoryModuleType.ATTACK_TARGET, Optional.empty());
        }
    }

    public static boolean areOwnerOrServants(LivingEntity entity1, LivingEntity entity2) {
        return EntityHelper.getOwnerOrSelfId(entity1).equals(EntityHelper.getOwnerOrSelfId(entity2));
    }

    private static UUID getOwnerOrSelfId(LivingEntity entity) {
        return Optional.ofNullable(TamableType.getType(entity)).map(t -> t.getOwnerId(entity)).orElse(entity.getUUID());
    }

    public static boolean isEnemy(@Nullable Entity entity) {
        TamableAnimal tamable;
        return entity instanceof Enemy && !EntityHelper.isServant(entity) && (!(entity instanceof TamableAnimal) || !(tamable = (TamableAnimal)entity).isTame());
    }

    public static boolean isServant(Entity entity) {
        return ServantUndeadHandler.hasCapability(entity) && ServantUndeadHandler.hasOwner(entity);
    }

    public static Optional<UUID> getServantOwnerId(Entity entity) {
        return ServantUndeadHandler.getOwnerId(entity);
    }

    public static Optional<Player> getServantOwner(Entity entity) {
        return EntityHelper.getServantOwnerId(entity).flatMap(ownerId -> Optional.ofNullable(entity.level().getPlayerByUUID(ownerId)));
    }

    public static boolean noGraveGuardianAround(Level level, BlockPos pos) {
        return level.getEntitiesOfClass(GraveGuardian.class, new AABB(pos).inflate((double)((Integer)ConfigTombstone.decorative_grave.distanceBetweenGraveGuardian.get()).intValue(), 20.0, (double)((Integer)ConfigTombstone.decorative_grave.distanceBetweenGraveGuardian.get()).intValue()), entity -> true).isEmpty();
    }
}

