/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Locale;
import java.util.function.Predicate;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.registry.ModTags;

public enum DamageCategory implements StringRepresentable
{
    EARTH(d -> d.is(ModTags.DamageTypes.EARTH)),
    FIRE(d -> d.is(ModTags.DamageTypes.FIRE)),
    AIR(d -> d.is(ModTags.DamageTypes.AIR)),
    WATER(d -> d.is(ModTags.DamageTypes.WATER)),
    DARKNESS(d -> d.is(ModTags.DamageTypes.DARKNESS)),
    LIGHT(d -> d.is(ModTags.DamageTypes.LIGHT)),
    UNKNOWN(d -> false);

    private final String name = this.name().toLowerCase(Locale.US);
    private final Predicate<DamageSource> is;

    private DamageCategory(Predicate<DamageSource> predic) {
        this.is = predic;
    }

    public static boolean isProjectile(@Nullable DamageSource damageSource) {
        return damageSource != null && damageSource.is(DamageTypeTags.IS_PROJECTILE);
    }

    public static boolean isExplosion(@Nullable DamageSource damageSource) {
        return damageSource != null && damageSource.is(DamageTypeTags.IS_EXPLOSION);
    }

    public static boolean isThorn(@Nullable DamageSource damageSource) {
        return damageSource != null && damageSource.is(DamageTypes.THORNS);
    }

    public boolean is(DamageSource s) {
        return this.is.test(s);
    }

    public static DamageCategory of(DamageSource s) {
        for (DamageCategory damageCategory : DamageCategory.values()) {
            if (!damageCategory.is(s)) continue;
            return damageCategory;
        }
        return UNKNOWN;
    }

    public String getSerializedName() {
        return this.name;
    }
}

