/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.api.cooldown.ICooldownHandler;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.ProxyHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.network.CMessageAllCooldowns;
import ovh.corail.tombstone.network.CMessageCooldown;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.registry.ModItems;

public final class CooldownHandler
implements ICooldownHandler {
    public static final CooldownHandler INSTANCE = new CooldownHandler();
    private final Map<UUID, EnumMap<CooldownType, Long>> cooldowns = new ConcurrentHashMap<UUID, EnumMap<CooldownType, Long>>();
    private EnumMap<CooldownType, Long> clientCooldowns = new EnumMap(CooldownType.class);
    public static final String COOLDOWNS_NBT_LIST = "tb_cooldowns";
    private static final String ID_NBT_BYTE = "id";
    private static final String CD_NBT_LONG = "cd";
    private static final BiPredicate<Tag, CooldownType> FIND_BY_TYPE = (nbt, type) -> ((CompoundTag)nbt).getByte(ID_NBT_BYTE) == (byte)type.ordinal();
    private static final Function<Byte, CooldownType> FIND_BY_ID = id -> id >= 0 && id < CooldownType.values().length ? CooldownType.values()[id] : null;

    private CooldownHandler() {
        CooldownType.NEXT_PRAY.setMaxCooldown(player -> TimeHelper.tickFromMinute((Integer)SharedConfigTombstone.decorative_grave.prayerCooldown.get()));
        CooldownType.RESET_PERKS.setMaxCooldown(player -> TimeHelper.tickFromMinute((Integer)SharedConfigTombstone.allowed_perks.cooldownResetPerk.get()));
        CooldownType.TELEPORT_DEATH.setMaxCooldown(player -> TimeHelper.tickFromMinute((Integer)ConfigTombstone.general.cooldownTeleportDeath.get()));
        CooldownType.REQUEST_TELEPORT.setMaxCooldown(player -> TimeHelper.tickFromMinute((Integer)ConfigTombstone.general.cooldownRequestTeleport.get()));
    }

    @Override
    public int getCooldown(Player player, CooldownType type) {
        if (player.level().isClientSide()) {
            return this.getCooldown(type);
        }
        EnumMap entry = this.cooldowns.computeIfAbsent(player.getGameProfile().getId(), aId -> this.computePlayerCd((ServerPlayer)player));
        long worldTimeCD = entry.getOrDefault((Object)type, -1L);
        if (worldTimeCD > 0L) {
            long cooldown = worldTimeCD - TimeHelper.worldTicks(player.level());
            if (cooldown <= 0L && entry.remove((Object)type) != null) {
                this.getCooldownTagList(player).removeIf(inbt -> FIND_BY_TYPE.test((Tag)inbt, type));
                return 0;
            }
            if (cooldown > (long)type.getMaxCooldown(player)) {
                return this.resetCooldown((ServerPlayer)player, type);
            }
            return Math.max((int)cooldown, 0);
        }
        return 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getCooldown(CooldownType type) {
        long cd = this.clientCooldowns.getOrDefault((Object)type, -1L);
        return cd > 0L ? ProxyHelper.getClientPlayer().map(player -> Math.max(0, (int)(cd - TimeHelper.worldTicks(player.level())))).orElse(0) : 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean hasCooldown(CooldownType type) {
        return this.getCooldown(type) > 0;
    }

    @Override
    public boolean hasCooldown(Player player, CooldownType type) {
        return this.getCooldown(player, type) > 0;
    }

    public boolean noCooldown(Player player, CooldownType type) {
        return this.getCooldown(player, type) <= 0;
    }

    @Override
    public int resetCooldown(ServerPlayer player, CooldownType type) {
        if (EntityHelper.isValidServerPlayer(player)) {
            int maxCD = type.getMaxCooldown((Player)player);
            this.setWorldTimeCooldown(player, type, TimeHelper.worldTicks(player.level()) + (long)maxCD);
            return maxCD;
        }
        return 0;
    }

    @Override
    public int setCooldown(ServerPlayer player, CooldownType type, int time) {
        if (EntityHelper.isValidServerPlayer(player)) {
            int cappedTime = Math.min(time, type.getMaxCooldown((Player)player));
            this.setWorldTimeCooldown(player, type, TimeHelper.worldTicks(player.level()) + (long)cappedTime);
            return cappedTime;
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateClientCooldown(CooldownType type, long worldTime) {
        this.clientCooldowns.put(type, worldTime);
        if (type == CooldownType.NEXT_PRAY) {
            ProxyHelper.getClientPlayer().ifPresent(player -> EntityHelper.removeGlobalItemCooldown(player, ModItems.ankh_of_prayer));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateAllClientCooldowns(ListTag tagList) {
        this.clientCooldowns = this.computePlayerCd(tagList);
        ProxyHelper.getClientPlayer().ifPresent(player -> EntityHelper.removeGlobalItemCooldown(player, ModItems.ankh_of_prayer));
    }

    private void setWorldTimeCooldown(ServerPlayer player, CooldownType type, long worldTime) {
        this.setWorldTimeCooldown(player, type, worldTime, true);
    }

    private void setWorldTimeCooldown(ServerPlayer player, CooldownType type, long worldTime, boolean checkSync) {
        ListTag tagList = this.getCooldownTagList((Player)player);
        boolean isSet = tagList.stream().filter(inbt -> FIND_BY_TYPE.test((Tag)inbt, type)).findFirst().map(inbt -> {
            ((CompoundTag)inbt).putLong(CD_NBT_LONG, worldTime);
            return true;
        }).orElse(false);
        if (!isSet) {
            this.writeCooldown(tagList, type, worldTime);
        }
        this.cooldowns.computeIfAbsent(player.getGameProfile().getId(), aId -> this.computePlayerCd(player)).put(type, worldTime);
        if (checkSync && type.isSync()) {
            PacketHandler.sendToPlayer(new CMessageCooldown(type, worldTime), player);
        }
    }

    public void updateWorldTime(ServerPlayer player, long modifier) {
        if (!EntityHelper.isValidServerPlayer(player)) {
            return;
        }
        boolean requirePacket = false;
        for (CooldownType type : CooldownType.values()) {
            int cd = this.getCooldown((Player)player, type);
            if (cd <= 0) continue;
            requirePacket = true;
            this.setWorldTimeCooldown(player, type, (long)cd + modifier, false);
        }
        if (requirePacket) {
            PacketHandler.sendToPlayer(this.getCooldownPacket(player), player);
        }
    }

    private EnumMap<CooldownType, Long> computePlayerCd(ServerPlayer player) {
        return this.computePlayerCd(this.getCooldownTagList((Player)player));
    }

    private EnumMap<CooldownType, Long> computePlayerCd(ListTag tagList) {
        EnumMap<CooldownType, Long> playerCooldowns = new EnumMap<CooldownType, Long>(CooldownType.class);
        tagList.forEach(inbt -> {
            CompoundTag nbt = (CompoundTag)inbt;
            CooldownType id = FIND_BY_ID.apply(nbt.getByte(ID_NBT_BYTE));
            if (id != null) {
                playerCooldowns.put(id, nbt.getLong(CD_NBT_LONG));
            }
        });
        return playerCooldowns;
    }

    private ListTag getCooldownTagList(Player player) {
        return NBTStackHelper.getListOrCreate(EntityHelper.getPersistentTag(player), COOLDOWNS_NBT_LIST);
    }

    public CMessageAllCooldowns getCooldownPacket(ServerPlayer player) {
        ListTag initTagList = this.getCooldownTagList((Player)player);
        EnumMap entry = this.cooldowns.computeIfAbsent(player.getGameProfile().getId(), aId -> this.computePlayerCd(initTagList));
        ListTag tagList = new ListTag();
        Arrays.stream(CooldownType.values()).filter(CooldownType::isSync).forEach(type -> {
            long worldTimeCD = entry.getOrDefault(type, -1L);
            if (worldTimeCD > 0L) {
                long cooldown = worldTimeCD - TimeHelper.worldTicks(player.level());
                int maxCD = type.getMaxCooldown((Player)player);
                if (cooldown <= 0L && entry.remove(type) != null) {
                    initTagList.removeIf(inbt -> FIND_BY_TYPE.test((Tag)inbt, (CooldownType)((Object)type)));
                    worldTimeCD = -1L;
                }
                if (cooldown > (long)maxCD) {
                    worldTimeCD = TimeHelper.worldTicks(player.level()) + (long)maxCD;
                    this.setWorldTimeCooldown(player, (CooldownType)((Object)type), worldTimeCD);
                }
            }
            this.writeCooldown(tagList, (CooldownType)((Object)type), worldTimeCD);
        });
        return new CMessageAllCooldowns(tagList);
    }

    private void writeCooldown(ListTag tagList, CooldownType type, long worldTime) {
        CompoundTag nbt = new CompoundTag();
        nbt.putByte(ID_NBT_BYTE, (byte)type.ordinal());
        nbt.putLong(CD_NBT_LONG, worldTime);
        tagList.add((Object)nbt);
    }

    public void clear() {
        this.cooldowns.clear();
    }
}

