/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import ovh.corail.tombstone.capability.PlayerAlignmentHandler;
import ovh.corail.tombstone.capability.PlayerKnowledgeHandler;
import ovh.corail.tombstone.gui.CustomButton;
import ovh.corail.tombstone.gui.ScreenCompendium;
import ovh.corail.tombstone.gui.ScreenConfig;
import ovh.corail.tombstone.gui.TBScreen;
import ovh.corail.tombstone.helper.FontHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.RenderHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemAdvancement;
import ovh.corail.tombstone.item.ItemEasterEgg;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SMessageUpgradePerk;
import ovh.corail.tombstone.perk.Perk;
import ovh.corail.tombstone.perk.PerkRegistry;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;

@OnlyIn(value=Dist.CLIENT)
public final class ScreenKnowledge
extends TBScreen {
    private static final ResourceLocation BOOK_PART = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"textures/item/book_part1.png");
    private final Player player;
    private final int upgradableLevelMax;
    private final List<PerkIcon> icons = new ArrayList<PerkIcon>();
    private PerkIcon hoveredIcon;
    private int leftPerkPoints;
    private final ItemStack stackSkull = ItemAdvancement.IconType.FIRST_KNOWLEDGE.getItemStack();
    private final ItemStack stackRevive = ItemAdvancement.IconType.REVIVE.getItemStack();
    private final ItemStack stackAnkh = ItemAdvancement.IconType.FIRST_PRAY.getItemStack();
    private final double alignmentPos;
    private final List<BonusIcon> bonusIcons = new ArrayList<BonusIcon>();

    public ScreenKnowledge(Player player) {
        super((Component)LangKey.MESSAGE_KNOWLEDGE_OF_DEATH.getText(new Object[0]));
        this.player = player;
        this.upgradableLevelMax = PlayerKnowledgeHandler.getTotalPerkPoints(this.player);
        PerkRegistry.values().forEach(perk -> this.icons.add(new PerkIcon((Perk)perk)));
        this.alignmentPos = this.getBarRatio();
        this.initBonusIcons();
    }

    @Override
    public void init() {
        super.init();
        int x = this.guiLeft + 15;
        int y = this.guiTop + 72;
        int i = 0;
        int spaceForIcon = 35;
        int maxIconByLine = 6;
        for (PerkIcon icon : this.icons) {
            int caseX = i % maxIconByLine;
            icon.setPosition(x + caseX * spaceForIcon, y);
            if (caseX == maxIconByLine - 1) {
                y += 40;
            }
            ++i;
        }
        int xIcon = this.guiLeft + 30;
        for (BonusIcon icon : this.bonusIcons) {
            icon.setPosition(xIcon, this.guiBottom - 45);
            xIcon += 18;
        }
        this.addRenderableWidget((GuiEventListener)new CustomButton(this.guiLeft + 10, this.guiBottom - 25, 70, 15, (Component)LangKey.MESSAGE_COMPENDIUM.getText(new Object[0]), pressable -> this.getMinecraft().setScreen((Screen)new ScreenCompendium())));
        this.addRenderableWidget((GuiEventListener)new CustomButton(this.guiRight - 10 - 70, this.guiBottom - 25, 70, 15, (Component)LangKey.MESSAGE_CONFIG.getText(new Object[0]), pressable -> this.getMinecraft().setScreen((Screen)new ScreenConfig())));
    }

    private void initBonusIcons() {
        ArrayList tooltips;
        int alignmentLevel;
        boolean isBad;
        TimeHelper.SpecialEvent specialEvent = TimeHelper.getSpecialEvent();
        if (specialEvent != TimeHelper.SpecialEvent.NONE) {
            String eventName;
            this.bonusIcons.add(new BonusIcon(this, switch (specialEvent) {
                case TimeHelper.SpecialEvent.HALLOWEEN -> {
                    eventName = "halloween";
                    yield ItemAdvancement.IconType.GHOST.getItemStack();
                }
                case TimeHelper.SpecialEvent.CHRISTMAS -> {
                    eventName = "christmas";
                    yield new ItemStack((ItemLike)ModItems.christmas_gift);
                }
                case TimeHelper.SpecialEvent.EASTER -> {
                    eventName = "easter";
                    yield ItemEasterEgg.ModelColor.BLUE.asItemStack();
                }
                default -> {
                    eventName = "april_fools_day";
                    yield new ItemStack((ItemLike)Items.TROPICAL_FISH);
                }
            }, Lists.newArrayList((Object[])new Component[]{Component.translatable((String)("tombstone.compendium." + eventName + ".title")).withStyle(ChatFormatting.BOLD), Component.translatable((String)"tombstone.message.holiday_event_bonus")})));
        }
        if ((isBad = (alignmentLevel = PlayerAlignmentHandler.getAlignmentLevel(this.player)) < 0) || alignmentLevel > 0) {
            tooltips = new ArrayList();
            tooltips.add((isBad ? LangKey.MESSAGE_DARKNESS : LangKey.MESSAGE_LIGHT).getText(ChatFormatting.BOLD, new Object[]{Helper.getRomanNumber(Math.abs(alignmentLevel))}));
            tooltips.add(Component.translatable((String)"tombstone.message.protect_against", (Object[])new Object[]{Component.translatable((String)("tombstone.message." + (isBad ? "living_damages" : "undead_damages"))), Math.abs(alignmentLevel * 10)}));
            this.bonusIcons.add(new BonusIcon(this, isBad ? this.stackSkull : this.stackRevive, tooltips));
        }
        tooltips = isBad ? Lists.newArrayList((Object[])new Component[]{Component.translatable((String)"tombstone.advancement.zombify.title").withStyle(ChatFormatting.BOLD), Component.translatable((String)"bonus.tombstone.zombify")}) : Lists.newArrayList((Object[])new Component[]{Component.translatable((String)"bonus.tombstone.exorcism.title").withStyle(ChatFormatting.BOLD), Component.translatable((String)"bonus.tombstone.exorcism")});
        this.bonusIcons.add(new BonusIcon(this, ItemAdvancement.IconType.EXORCISM.getItemStack(), tooltips));
        if (alignmentLevel > 0) {
            this.bonusIcons.add(new BonusIcon(this, ItemAdvancement.IconType.PRAY_OF_PROTECTION.getItemStack(), Lists.newArrayList((Object[])new Component[]{Component.translatable((String)"tombstone.advancement.pray_of_protection.title").withStyle(ChatFormatting.BOLD), Component.translatable((String)"bonus.tombstone.pray_of_protection")})));
        }
        if (alignmentLevel > 2) {
            this.bonusIcons.add(new BonusIcon(this, ItemAdvancement.IconType.GOLD_HEART.getItemStack(), Lists.newArrayList((Object[])new Component[]{Component.translatable((String)"bonus.tombstone.pray_of_harmonization.title").withStyle(ChatFormatting.BOLD), Component.translatable((String)"bonus.tombstone.pray_of_harmonization")})));
        } else if (alignmentLevel > 1) {
            this.bonusIcons.add(new BonusIcon(this, new ItemStack((ItemLike)Items.LEAD), Lists.newArrayList((Object[])new Component[]{Component.translatable((String)"bonus.tombstone.pray_of_empathy.title").withStyle(ChatFormatting.BOLD), Component.translatable((String)"bonus.tombstone.pray_of_empathy")})));
        }
        if (alignmentLevel < -2) {
            this.bonusIcons.add(new BonusIcon(this, ItemAdvancement.IconType.BLACK_NOTE.getItemStack(), Lists.newArrayList((Object[])new Component[]{Component.translatable((String)"bonus.tombstone.pray_of_dissonance.title").withStyle(ChatFormatting.BOLD), Component.translatable((String)"bonus.tombstone.pray_of_dissonance")})));
        } else if (alignmentLevel < -1) {
            this.bonusIcons.add(new BonusIcon(this, new ItemStack((ItemLike)Items.GHAST_TEAR), Lists.newArrayList((Object[])new Component[]{Component.translatable((String)"bonus.tombstone.pray_of_undead.title").withStyle(ChatFormatting.BOLD), Component.translatable((String)"bonus.tombstone.pray_of_undead")})));
        }
        this.bonusIcons.forEach(bonusIcon -> bonusIcon.tooltips.replaceAll(FontHelper::withFantasyFont));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.hoveredIcon != null) {
            if (mouseButton == 0 && !this.hoveredIcon.perk.isDisabled(this.player)) {
                int perkLevel = PlayerKnowledgeHandler.getPerkLevel(this.player, this.hoveredIcon.perk);
                if (perkLevel < Math.min(this.hoveredIcon.perk.getLevelMax(), this.upgradableLevelMax) && this.leftPerkPoints >= this.hoveredIcon.perk.getCost(perkLevel + 1)) {
                    PacketHandler.sendToServer(new SMessageUpgradePerk(SMessageUpgradePerk.SyncType.UPGRADE_PERK, this.hoveredIcon.perk));
                    return true;
                }
            } else if (mouseButton == 1 && this.player.isCreative() && PlayerKnowledgeHandler.getPerkLevel(this.player, this.hoveredIcon.perk) > 0) {
                PacketHandler.sendToServer(new SMessageUpgradePerk(SMessageUpgradePerk.SyncType.DOWNGRADE_PERK, this.hoveredIcon.perk));
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.hoveredIcon = this.icons.stream().filter(p -> p.contains(mouseX, mouseY)).findFirst().orElse(null);
        int totalPerkPoints = PlayerKnowledgeHandler.getTotalPerkPoints(this.player);
        int usedPerkPoints = PlayerKnowledgeHandler.getUsedPerkPoints(this.player);
        this.leftPerkPoints = totalPerkPoints - usedPerkPoints;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Matrix4f matrix = guiGraphics.pose().last().pose();
        guiGraphics.hLine(this.guiLeft + 5, this.guiRight - 5, this.guiTop + 4, -1);
        guiGraphics.hLine(this.guiLeft + 5, this.guiRight - 5, this.guiTop + 6, -1);
        FontHelper.drawCenteredFantasy(guiGraphics, this.font, (Component)LangKey.MESSAGE_KNOWLEDGE_OF_DEATH.getText(new Object[0]), this.halfWidth, this.guiTop + 10, -1);
        guiGraphics.hLine(this.guiLeft + 5, this.guiRight - 5, this.guiTop + 20, -1);
        guiGraphics.hLine(this.guiLeft + 5, this.guiRight - 5, this.guiTop + 22, -1);
        RenderHelper.Sprites.BAR_BACKGROUND_SPRITE.render(guiGraphics, this.guiLeft + 52, this.guiTop + 30, 0.9f);
        RenderHelper.Sprites.BAR_NOTCHED_12_SPRITE.render(guiGraphics, this.guiLeft + 52, this.guiTop + 31, 0.9f);
        int currentLevelKnowledge = PlayerKnowledgeHandler.getKnowledgeForLevel(totalPerkPoints);
        RenderHelper.Sprites.BAR_PROGRESS_SPRITE.render(guiGraphics, this.guiLeft + 52, this.guiTop + 30, 0.9f * (float)(PlayerKnowledgeHandler.getKnowledge(this.player) - currentLevelKnowledge) / (float)(PlayerKnowledgeHandler.getKnowledgeForLevel(totalPerkPoints + 1) - currentLevelKnowledge), 0.9f);
        int startAlignmentY = 44;
        FontHelper.drawCenteredFantasy(guiGraphics, this.font, (Component)LangKey.MESSAGE_ALIGNMENT.getText(new Object[0]), this.halfWidth, this.guiTop + startAlignmentY - 4, -1);
        guiGraphics.fill(this.guiLeft + 20, this.guiTop + startAlignmentY + 10, this.guiRight - 20, this.guiTop + startAlignmentY + 17, -16777216);
        RenderHelper.fillGradient(matrix, this.guiLeft + 21, this.guiTop + startAlignmentY + 11, this.halfWidth, this.guiTop + startAlignmentY + 16, -65536, -1, 0, true);
        RenderHelper.fillGradient(matrix, this.halfWidth, this.guiTop + startAlignmentY + 11, this.guiRight - 21, this.guiTop + startAlignmentY + 16, -1, -16776961, 0, true);
        Objects.requireNonNull(this);
        float step = (float)(230 - 42) / 8.0f;
        for (int i = 0; i < 8; ++i) {
            if (i == 4) continue;
            guiGraphics.vLine(this.guiLeft + 21 + (int)((float)i * step), this.guiTop + startAlignmentY + 10, this.guiTop + startAlignmentY + 16, -16777216);
        }
        guiGraphics.renderItem(this.stackSkull, this.guiLeft + 10, this.guiTop + startAlignmentY + 5);
        guiGraphics.renderItem(this.stackRevive, this.guiRight - 10 - 16, this.guiTop + startAlignmentY + 5);
        Objects.requireNonNull(this);
        int adjust = (int)Math.round((double)(230 - 42) / 2.0 * this.alignmentPos);
        guiGraphics.renderItem(this.stackAnkh, this.halfWidth + adjust - 8, this.guiTop + startAlignmentY + 4);
        String levelString = this.leftPerkPoints + " / " + totalPerkPoints;
        FontHelper.drawFantasy(guiGraphics, this.font, (Component)Component.literal((String)levelString), this.guiLeft + 48 - this.font.width(levelString), this.guiTop + 28, -1);
        this.icons.forEach(icon -> this.drawPerk(guiGraphics, (PerkIcon)icon));
        this.bonusIcons.forEach(icon -> icon.render(guiGraphics));
        if (this.hoveredIcon == null) {
            this.bonusIcons.stream().filter(icon -> icon.contains(mouseX, mouseY)).findFirst().ifPresent(icon -> guiGraphics.renderComponentTooltip(this.font, icon.tooltips, icon.minX + 10, icon.minY + 10));
        }
        this.drawPerkTooltip(guiGraphics);
    }

    private double getBarRatio() {
        boolean isPositive = PlayerAlignmentHandler.getAlignmentValue(this.player) >= 0;
        int alignment = Math.abs(Mth.clamp((int)PlayerAlignmentHandler.getAlignmentValue(this.player), (int)PlayerAlignmentHandler.getAlignmentMinValue(), (int)PlayerAlignmentHandler.getAlignmentMaxValue()));
        double ratio = alignment > 3000 ? 0.75 + 0.25 * (double)(alignment - 3000) * 5.0E-4 : (alignment > 1500 ? 0.5 + 0.25 * (double)(alignment - 1500) / 1500.0 : (alignment > 500 ? 0.25 + 0.25 * (double)(alignment - 500) * 0.001 : 0.25 * (double)alignment * 0.002));
        return isPositive ? ratio : -ratio;
    }

    private void drawPerk(GuiGraphics guiGraphics, PerkIcon icon) {
        boolean isGray;
        int baseLevel = PlayerKnowledgeHandler.getPerkLevel(this.player, icon.perk);
        int levelWithBonus = PlayerKnowledgeHandler.getPerkLevelWithBonus(this.player, icon.perk);
        boolean isHovered = icon.equals(this.hoveredIcon);
        boolean isMax = baseLevel == icon.perk.getLevelMax();
        boolean isDisabled = icon.perk.isDisabled(this.player);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.fill(icon.minX, icon.minY + 25 - 1, icon.maxX - 1, icon.maxY, -15329733);
        boolean bl = isGray = isDisabled || levelWithBonus == 0 && !isHovered;
        if (isGray) {
            RenderSystem.setShaderColor((float)0.13f, (float)0.13f, (float)0.13f, (float)0.13f);
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        guiGraphics.blit(FRAME, icon.minX, icon.minY, 0.0f, 0.0f, 24, 24, 24, 24);
        guiGraphics.blit(icon.perk.getIcon(), icon.minX + 2, icon.minY + 2, 0.0f, 0.0f, 20, 20, 20, 20);
        if (icon.perk.equals(ModPerks.scribe)) {
            if (!isGray) {
                RenderSystem.setShaderColor((float)0.4117647f, (float)0.45882353f, (float)0.5176471f, (float)1.0f);
            }
            guiGraphics.blit(BOOK_PART, icon.minX + 2, icon.minY + 2, 0.0f, 0.0f, 20, 20, 20, 20);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (isHovered) {
            int color = isDisabled ? -65536 : (isMax ? -1980292 : -7096363);
            guiGraphics.hLine(icon.minX - 1, icon.maxX - 1, icon.minY - 1, color);
            guiGraphics.hLine(icon.minX - 1, icon.maxX - 1, icon.maxY, color);
            guiGraphics.vLine(icon.minX - 1, icon.minY - 1, icon.maxY, color);
            guiGraphics.vLine(icon.maxX - 1, icon.minY - 1, icon.maxY, color);
        }
        boolean hasBonus = icon.perk.getLevelBonus(this.player) != 0;
        MutableComponent perkLevelText = Component.literal((String)("" + baseLevel)).setStyle(isDisabled ? StyleType.COLOR_OFF : (isMax ? StyleType.PERK_TEXT_MAX : (baseLevel > 0 ? StyleType.PERK_TEXT_DEFAULT : StyleType.PERK_TEXT_DISABLE)));
        if (hasBonus && !isDisabled) {
            perkLevelText.append((Component)Component.literal((String)("(" + levelWithBonus + ")")).withStyle(StyleType.PERK_TEXT_BONUS));
        }
        FontHelper.drawCenteredFantasy(guiGraphics, this.font, (Component)perkLevelText, (float)(icon.minX + icon.maxX) / 2.0f, icon.maxY - 8, -1);
    }

    private void drawPerkTooltip(GuiGraphics guiGraphics) {
        if (this.hoveredIcon != null) {
            int baseLevel = PlayerKnowledgeHandler.getPerkLevel(this.player, this.hoveredIcon.perk);
            int levelWithBonus = PlayerKnowledgeHandler.getPerkLevelWithBonus(this.player, this.hoveredIcon.perk);
            int levelMax = this.hoveredIcon.perk.getLevelMax();
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(this.hoveredIcon.perk.getTranslation().copy().withStyle(StyleType.MESSAGE_SPECIAL));
            list.add(Component.translatable((String)(this.hoveredIcon.perk.getTranslationKey() + ".desc")).withStyle(ChatFormatting.DARK_GRAY));
            list.add(LangKey.TOOLTIP_ACTUAL_BONUS.getText(new Object[0]).withStyle(StyleType.INFO));
            ChatFormatting chatFormatting = levelWithBonus > baseLevel ? ChatFormatting.DARK_PURPLE : ChatFormatting.WHITE;
            this.hoveredIcon.perk.getCurrentBonusInfo(levelWithBonus).forEach(info -> list.add(info.copy().withStyle(chatFormatting)));
            if (this.hoveredIcon.perk.isDisabled(this.player)) {
                list.add(this.hoveredIcon.perk.getDisabledInfo(this.player).plainCopy().setStyle(StyleType.COLOR_OFF));
            } else if (baseLevel < levelMax) {
                int cost;
                if (levelWithBonus < levelMax) {
                    list.add(LangKey.TOOLTIP_NEXT_BONUS.getText(new Object[0]).withStyle(StyleType.INFO));
                    this.hoveredIcon.perk.getNextBonusInfo(levelWithBonus + 1).forEach(info -> list.add(info.copy().withStyle(ChatFormatting.GRAY)));
                }
                boolean hasPerkPoints = this.leftPerkPoints >= (cost = this.hoveredIcon.perk.getCost(baseLevel + 1));
                list.add(LangKey.MESSAGE_COST.getText(hasPerkPoints ? ChatFormatting.AQUA : ChatFormatting.RED, new Object[]{cost}));
                list.add(baseLevel < this.upgradableLevelMax && hasPerkPoints ? LangKey.MESSAGE_CLICK_TO_UPGRADE.getText(ChatFormatting.BLUE, new Object[0]) : LangKey.MESSAGE_CANT_UPGRADE.getText(ChatFormatting.RED, new Object[0]));
            } else {
                list.add(LangKey.MESSAGE_MAX.getText(ChatFormatting.GOLD, new Object[0]));
            }
            list.replaceAll(FontHelper::withFantasyFont);
            guiGraphics.renderComponentTooltip(this.font, list, this.hoveredIcon.minX + 17, this.hoveredIcon.minY);
        }
    }

    private static class PerkIcon {
        public static final int ICON_SIZE = 25;
        private final Perk perk;
        private int minX;
        private int minY;
        private int maxX;
        private int maxY;

        PerkIcon(Perk perk) {
            this.perk = perk;
        }

        void setPosition(int x, int y) {
            this.minX = x;
            this.minY = y;
            this.maxX = x + 25;
            this.maxY = y + 25 + 10;
        }

        boolean contains(double mouseX, double mouseY) {
            return mouseX >= (double)this.minX && mouseY >= (double)this.minY && mouseX <= (double)this.maxX && mouseY <= (double)this.maxY;
        }
    }

    private class BonusIcon {
        public static final int ICON_SIZE = 16;
        private final ItemStack stack;
        private final List<Component> tooltips;
        private int minX;
        private int minY;
        private int maxX;
        private int maxY;

        BonusIcon(ScreenKnowledge screenKnowledge, ItemStack stack, List<Component> tooltips) {
            this.stack = stack;
            this.tooltips = tooltips;
        }

        void setPosition(int x, int y) {
            this.minX = x;
            this.minY = y;
            this.maxX = x + 16;
            this.maxY = y + 16;
        }

        boolean contains(double mouseX, double mouseY) {
            return mouseX >= (double)this.minX && mouseY >= (double)this.minY && mouseX <= (double)this.maxX && mouseY <= (double)this.maxY;
        }

        private void render(GuiGraphics guiGraphics) {
            guiGraphics.fill(this.minX - 1, this.minY - 1, this.maxX + 1, this.maxY + 1, -15329733);
            guiGraphics.fillGradient(this.minX, this.minY, this.maxX, this.maxY, -16703669, -7096363);
            guiGraphics.renderItem(this.stack, this.minX, this.minY);
        }
    }
}

