/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.gui.CompendiumData;
import ovh.corail.tombstone.gui.CustomButton;
import ovh.corail.tombstone.gui.TBScreen;
import ovh.corail.tombstone.helper.FontHelper;
import ovh.corail.tombstone.helper.LangKey;

@OnlyIn(value=Dist.CLIENT)
public final class ScreenCompendium
extends TBScreen {
    private CompendiumData currentInfo;
    @Nullable
    private CompendiumData.CompendiumLabel hoveredInfo = null;
    private int currentPage = 0;
    private Button previousPage;
    private Button nextPage;

    ScreenCompendium() {
        this(CompendiumData.CompendiumLabel.COMPENDIUM);
    }

    public ScreenCompendium(CompendiumData.CompendiumLabel currentInfo) {
        super((Component)LangKey.MESSAGE_COMPENDIUM.getText(new Object[0]));
        this.currentInfo = CompendiumData.getInfo(currentInfo);
    }

    @Override
    public void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new CustomButton(this.halfWidth - 35, this.guiBottom - 25, 70, 15, (Component)LangKey.MESSAGE_BACK.getText(new Object[0]), pressable -> {
            if (this.currentInfo.isIndex()) {
                this.getThePlayer().closeContainer();
            } else {
                this.updateInfoAndButtons(CompendiumData.CompendiumLabel.COMPENDIUM);
            }
        }));
        this.previousPage = new PageButton(this.halfWidth - 23 - 65, this.guiBottom - 25, false, pressable -> this.changePage(this.currentPage - 1), true);
        this.addRenderableWidget((GuiEventListener)this.previousPage);
        this.nextPage = new PageButton(this.halfWidth + 65, this.guiBottom - 25, true, pressable -> this.changePage(this.currentPage + 1), true);
        this.addRenderableWidget((GuiEventListener)this.nextPage);
        this.updateButtons();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0 && this.hoveredInfo != null) {
            this.updateInfoAndButtons(this.hoveredInfo);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    private void changePage(int pageNum) {
        if (pageNum >= 0 && pageNum < this.currentInfo.getPageMax()) {
            this.currentPage = pageNum;
            this.updateButtons();
        }
    }

    private void updateInfoAndButtons(CompendiumData.CompendiumLabel info) {
        this.currentInfo = CompendiumData.getInfo(info);
        this.currentPage = 0;
        this.updateButtons();
    }

    private void updateButtons() {
        this.previousPage.visible = this.currentPage > 0;
        this.previousPage.active = this.previousPage.visible;
        this.nextPage.visible = this.currentPage < this.currentInfo.getPageMax() - 1;
        this.nextPage.active = this.nextPage.visible;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        Objects.requireNonNull(this);
        Objects.requireNonNull(this.font);
        guiGraphics.fill(this.guiLeft + 5, this.guiTop + 5, this.guiLeft + 230 - 5, this.guiTop + 20 + 9, 0x55000000);
        FontHelper.drawCentered(guiGraphics, this.font, this.currentInfo.getTitle(), (float)this.halfWidth, (float)(this.guiTop + 15), -1);
        if (!this.currentInfo.isIndex()) {
            MutableComponent mutableComponent = Component.literal((String)(this.currentPage + 1 + "/" + this.currentInfo.getPageMax()));
            Objects.requireNonNull(this);
            FontHelper.drawFantasy(guiGraphics, this.font, (Component)mutableComponent, this.guiLeft + 230 - 30, this.guiTop + 8, -1);
        }
        if (!this.currentInfo.getIcon().isEmpty()) {
            guiGraphics.fill(this.guiLeft + 8, this.guiTop + 8, this.guiLeft + 26, this.guiTop + 26, 0x10FFFFFF);
            guiGraphics.blit(FRAME, this.guiLeft + 7, this.guiTop + 7, 0.0f, 0.0f, 21, 21, 21, 21);
            guiGraphics.renderItem(this.currentInfo.getIcon(), this.guiLeft + 9, this.guiTop + 9);
        }
        this.drawDescription(guiGraphics);
        Objects.requireNonNull(this);
        int minX = this.guiLeft + 230 + 5;
        int minY = this.guiTop + 40;
        this.hoveredInfo = null;
        for (CompendiumData.CompendiumLabel link : this.currentInfo.getLinks()) {
            int maxX = minX + this.font.width((FormattedText)link.getTitle());
            Objects.requireNonNull(this.font);
            int maxY = minY + 9;
            boolean isHovered = false;
            if (this.hoveredInfo == null && mouseX >= minX && mouseX <= maxX && mouseY >= minY && mouseY <= maxY) {
                this.hoveredInfo = link;
                isHovered = true;
            }
            guiGraphics.drawString(this.font, link.getTitle(), minX, minY + 1, isHovered ? -1875 : -1);
            minY = maxY + 1;
        }
    }

    private void drawDescription(GuiGraphics guiGraphics) {
        int minX = this.guiLeft + 10;
        int minY = this.guiTop + 60;
        List<FormattedCharSequence> lines = this.currentInfo.getPage(this.currentPage);
        Objects.requireNonNull(this);
        Objects.requireNonNull(this.font);
        guiGraphics.fill(minX - 5, minY - 5, this.guiLeft + 230 - 5, minY + 5 + (9 + 1) * lines.size(), 0x55000000);
        for (int i = 0; i < lines.size(); ++i) {
            FormattedCharSequence line = lines.get(i);
            Objects.requireNonNull(this.font);
            guiGraphics.drawString(this.font, line, minX, minY + 2 + i * (9 + 1), -1);
        }
    }
}

