/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.event;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import ovh.corail.tombstone.api.event.CaptureSoulEvent;
import ovh.corail.tombstone.api.event.MerchantOffersEvent;
import ovh.corail.tombstone.api.event.PhantomSpawnerEvent;
import ovh.corail.tombstone.api.event.RestoreInventoryEvent;
import ovh.corail.tombstone.api.event.VillageSiegeEvent;
import ovh.corail.tombstone.blockEntity.BlockEntityPlayerGrave;
import ovh.corail.tombstone.entity.AbstractMerchant;

public class EventFactory {
    public static boolean onVillageSiegeStart(ServerLevel level, BlockPos spawnPos) {
        return ((VillageSiegeEvent.Start)NeoForge.EVENT_BUS.post((Event)new VillageSiegeEvent.Start(level, spawnPos))).isCanceled();
    }

    public static boolean onVillageSiegeZombieSpawn(ServerLevel level, Zombie entity) {
        return ((VillageSiegeEvent.SpawnZombie)NeoForge.EVENT_BUS.post((Event)new VillageSiegeEvent.SpawnZombie(level, entity))).isCanceled();
    }

    public static void onRestoreInventory(Player player, BlockEntityPlayerGrave tileGrave) {
        NeoForge.EVENT_BUS.post((Event)new RestoreInventoryEvent(player, tileGrave.getBlockPos(), tileGrave.getInventory(), tileGrave.getOwnerName(), tileGrave.getOwnerDeathTime()));
    }

    public static boolean onCaptureSoul(Player player, LivingEntity capturedEntity) {
        return ((CaptureSoulEvent)NeoForge.EVENT_BUS.post((Event)new CaptureSoulEvent(player, capturedEntity))).isCanceled();
    }

    public static int onPhantomTime(Player player, int timeForCheck) {
        PhantomSpawnerEvent.TimeForCheck event = new PhantomSpawnerEvent.TimeForCheck(player, timeForCheck);
        NeoForge.EVENT_BUS.post((Event)event);
        return event.getTimeForCheck();
    }

    public static boolean onCheckPhantomSpawn(Player player, int timeForCheck, int timeSinceRest, boolean result) {
        if (result) {
            PhantomSpawnerEvent.CheckPhantomSpawn event = new PhantomSpawnerEvent.CheckPhantomSpawn(player, timeForCheck, timeSinceRest);
            NeoForge.EVENT_BUS.post((Event)event);
        }
        return result;
    }

    public static void onInitGraveGuardianOffers(AbstractMerchant merchant) {
        NeoForge.EVENT_BUS.post((Event)new MerchantOffersEvent(merchant, merchant.getTradeLevel(), merchant.getOffers()));
    }
}

