/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.event;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.client.event.RenderBlockScreenEffectEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.capability.PlayerKnowledgeHandler;
import ovh.corail.tombstone.command.ISubCommand;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.gui.CompendiumData;
import ovh.corail.tombstone.gui.CustomOptionsRowList;
import ovh.corail.tombstone.gui.ScreenCompendium;
import ovh.corail.tombstone.gui.ScreenConfig;
import ovh.corail.tombstone.gui.ScreenKnowledge;
import ovh.corail.tombstone.gui.TBScreen;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.FontHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.MarkerHandler;
import ovh.corail.tombstone.helper.ProxyHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SMessageResetPerk;
import ovh.corail.tombstone.particle.ParticleGhost;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModDataComponents;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModKeybinds;

@EventBusSubscriber(value={Dist.CLIENT}, modid="tombstone", bus=EventBusSubscriber.Bus.GAME)
public final class ClientEventHandler {
    private static OpeningGui openingGui = OpeningGui.NONE;
    private static CompendiumData.CompendiumLabel compendiumLabel = CompendiumData.CompendiumLabel.COMPENDIUM;
    private static boolean isFirstGuiGameOver = false;
    public static boolean hasTrueSight = false;
    public static boolean hasWaterVision = false;
    private static long nextGhostTime = -1L;
    public static String toDisplay;
    private static int earnedLevel;
    private static int displayLeftTime;
    private static final SuggestionProvider<CommandSourceStack> LABEL_SUGGESTION;
    private static long LAST_PACKET;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onClientTick(ClientTickEvent.Pre event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.isPaused()) {
            return;
        }
        if (mc.player == null || mc.level == null) {
            hasWaterVision = false;
            hasTrueSight = false;
            return;
        }
        hasTrueSight = mc.player.hasEffect(ModEffects.ghostly_shape) || mc.player.hasEffect(ModEffects.true_sight);
        hasWaterVision = hasTrueSight || mc.player.hasEffect(ModEffects.aquatic_life);
        toDisplay = null;
        if (displayLeftTime > 0 && --displayLeftTime == 0) {
            LangKey.MESSAGE_ACCESS_GUI.sendSpecialMessage((Player)mc.player, earnedLevel, LangKey.MESSAGE_HERE.createComponentCommand("/tbgui", new Object[0]));
            earnedLevel = 0;
        }
        MarkerHandler.instance.update(mc);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onClientTick(ClientTickEvent.Post event) {
        TBScreen screen;
        Minecraft mc = Minecraft.getInstance();
        if (mc.isPaused()) {
            return;
        }
        if (mc.player == null || mc.level == null) {
            hasWaterVision = false;
            hasTrueSight = false;
            return;
        }
        switch (openingGui.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 1: {
                TBScreen tBScreen = new ScreenKnowledge((Player)mc.player);
                break;
            }
            case 2: {
                TBScreen tBScreen = new ScreenConfig();
                break;
            }
            case 3: {
                TBScreen tBScreen = new ScreenCompendium(compendiumLabel);
                break;
            }
            case 0: {
                TBScreen tBScreen = screen = null;
            }
        }
        if (screen == null) {
            if (mc.screen == null || mc.screen instanceof ChatScreen) {
                if (ModKeybinds.KEYBIND_COMPENDIUM.consumeClick()) {
                    openingGui = OpeningGui.COMPENDIUM;
                } else if (ModKeybinds.KEYBIND_CONFIG.consumeClick()) {
                    openingGui = OpeningGui.CONFIG;
                } else if (ModKeybinds.KEYBIND_KNOWLEDGE.consumeClick()) {
                    openingGui = OpeningGui.KNOWLEDGE;
                }
            }
        } else {
            openingGui = OpeningGui.NONE;
            mc.setScreen((Screen)screen);
        }
        if (((Boolean)ConfigTombstone.client.enableHalloweenGhost.get()).booleanValue() && TimeHelper.isDateAroundHalloween()) {
            if (Helper.isNight((Level)mc.level)) {
                long time = TimeHelper.worldTicks((Level)mc.level);
                if (nextGhostTime == -1L || time > nextGhostTime) {
                    if (nextGhostTime > -1L && CooldownHandler.INSTANCE.noCooldown((Player)mc.player, CooldownType.NEXT_PRAY)) {
                        Vec3 ghostVec = mc.player.position().add((Helper.RANDOM.nextDouble() - 0.5) * 18.0, 0.0, (Helper.RANDOM.nextDouble() - 0.5) * 18.0);
                        mc.particleEngine.add((Particle)new ParticleGhost(mc.level, ghostVec.x, ghostVec.y, ghostVec.z, 0.0, 0.0));
                    }
                    nextGhostTime = time + (long)Helper.RANDOM.nextInt(30000) + 6000L;
                }
            } else {
                nextGhostTime = -1L;
            }
        }
    }

    @SubscribeEvent
    public static void onRegisterCommand(RegisterClientCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tbgui").executes(c -> ClientEventHandler.openingGui(OpeningGui.KNOWLEDGE))).then(OpeningGui.KNOWLEDGE.literal().executes(c -> ClientEventHandler.openingGui(OpeningGui.KNOWLEDGE)))).then(OpeningGui.CONFIG.literal().executes(c -> ClientEventHandler.openingGui(OpeningGui.CONFIG)))).then(((LiteralArgumentBuilder)OpeningGui.COMPENDIUM.literal().executes(c -> ClientEventHandler.openingCompendium())).then(Commands.argument((String)"label", (ArgumentType)StringArgumentType.word()).suggests(LABEL_SUGGESTION).executes(c -> ClientEventHandler.openingCompendium(StringArgumentType.getString((CommandContext)c, (String)"label"))))));
    }

    private static int openingGui(OpeningGui gui) {
        openingGui = gui;
        compendiumLabel = CompendiumData.CompendiumLabel.COMPENDIUM;
        return 1;
    }

    private static int openingCompendium() {
        return ClientEventHandler.openingGui(OpeningGui.COMPENDIUM);
    }

    private static int openingCompendium(String labelString) throws CommandSyntaxException {
        CompendiumData.CompendiumLabel label = CompendiumData.CompendiumLabel.fromString(labelString);
        if (label == null) {
            throw LangKey.MESSAGE_INVALID_LABEL.asCommandException(new Object[0]);
        }
        openingGui = OpeningGui.COMPENDIUM;
        compendiumLabel = label;
        return 1;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGuiOpened(ScreenEvent.Opening event) {
        if (event.getScreen() instanceof DeathScreen && ((Boolean)ConfigTombstone.client.skipRespawnScreen.get()).booleanValue()) {
            ProxyHelper.getClientPlayer().ifPresent(player -> {
                if (!player.level().getLevelData().isHardcore()) {
                    isFirstGuiGameOver = !isFirstGuiGameOver;
                    event.setCanceled(true);
                    if (!isFirstGuiGameOver) {
                        player.respawn();
                    }
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onFogDensity(ViewportEvent.RenderFog event) {
        FluidState fluidState;
        boolean isWater;
        if (hasWaterVision && ((isWater = (fluidState = event.getCamera().getBlockAtCamera().getFluidState()).is(FluidTags.WATER)) || hasTrueSight && fluidState.is(FluidTags.LAVA))) {
            event.setCanceled(true);
            event.setFarPlaneDistance(192.0f * (isWater ? 1.0f : 0.09375f));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRenderFogHigh(ViewportEvent.ComputeFogColor event) {
        ProxyHelper.getClientPlayer().ifPresent(player -> {
            if (hasTrueSight && !player.hasEffect(MobEffects.NIGHT_VISION) && !player.hasEffect(MobEffects.DARKNESS) && event.getRed() != 0.0f && event.getGreen() != 0.0f && event.getBlue() != 0.0f) {
                float f9 = Math.min(1.0f / event.getRed(), Math.min(1.0f / event.getGreen(), 1.0f / event.getBlue()));
                float f7 = GameRenderer.getNightVisionScale((LivingEntity)player, (float)((float)event.getPartialTick()));
                event.setRed(event.getRed() * (1.0f - f7) + event.getRed() * f9 * f7);
                event.setGreen(event.getGreen() * (1.0f - f7) + event.getGreen() * f9 * f7);
                event.setBlue(event.getBlue() * (1.0f - f7) + event.getBlue() * f9 * f7);
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderFog(ViewportEvent.ComputeFogColor event) {
        if (hasWaterVision) {
            FluidState fluidState = event.getCamera().getBlockAtCamera().getFluidState();
            if (fluidState.is(FluidTags.WATER)) {
                event.setRed(0.09f);
                event.setGreen(0.42f);
                event.setBlue(0.93f);
            } else if (fluidState.is(FluidTags.LAVA) && hasTrueSight) {
                event.setRed(1.0f);
                event.setGreen(0.32f);
                event.setBlue(0.09f);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRenderBlockLayer(RenderBlockScreenEffectEvent event) {
        if (hasWaterVision && (event.getOverlayType() == RenderBlockScreenEffectEvent.OverlayType.WATER || event.getOverlayType() == RenderBlockScreenEffectEvent.OverlayType.FIRE && hasTrueSight)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handleTooltip(ItemTooltipEvent event) {
        if (event.getEntity() == null) {
            return;
        }
        if (((Boolean)event.getItemStack().getOrDefault(ModDataComponents.SOULBOUND, (Object)false)).booleanValue()) {
            event.getToolTip().add(Component.translatable((String)"tombstone.rune.soulbound").setStyle(StyleType.RUNE));
        }
        if (!SupportMods.ENCH_DESC.isLoaded() && ((Boolean)ConfigTombstone.client.showInfoOnEnchantment.get()).booleanValue()) {
            ItemEnchantments itemEnchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)event.getItemStack());
            if (itemEnchantments.isEmpty()) {
                return;
            }
            for (Holder enchantmentHolder : itemEnchantments.keySet()) {
                enchantmentHolder.unwrapKey().map(ResourceKey::location).filter(rl -> rl.getNamespace().equals("tombstone")).ifPresent(rl -> {
                    String enchantmentDescription = "enchantment.tombstone." + rl.getPath();
                    IntStream.range(0, event.getToolTip().size()).filter(line -> {
                        TranslatableContents contents;
                        Component currentTooltip = (Component)event.getToolTip().get(line);
                        ComponentContents patt0$temp = currentTooltip.getContents();
                        return patt0$temp instanceof TranslatableContents && enchantmentDescription.equals((contents = (TranslatableContents)patt0$temp).getKey());
                    }).findFirst().ifPresent(line -> event.getToolTip().add(++line, Component.translatable((String)(enchantmentDescription + ".desc")).setStyle(StyleType.TOOLTIP_ENCHANT)));
                });
            }
        }
    }

    @SubscribeEvent
    public static void render(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.player != null && mc.level != null) {
                MarkerHandler.instance.renderBox(new PoseStack());
            }
        }
    }

    public static void renderScreenMessage() {
        int minY;
        int halfWidth;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            toDisplay = null;
            earnedLevel = 0;
            displayLeftTime = 0;
            return;
        }
        if (mc.screen != null && !(mc.screen instanceof ChatScreen)) {
            if (mc.screen instanceof ScreenConfig) {
                CustomOptionsRowList.displayTooltip();
            }
            return;
        }
        if (mc.isPaused()) {
            return;
        }
        if (toDisplay != null) {
            halfWidth = mc.getWindow().getGuiScaledWidth() / 2;
            minY = 50;
            int halfLength = mc.font.width(toDisplay) / 2;
            GuiGraphics guiGraphics = new GuiGraphics(mc, mc.renderBuffers().bufferSource());
            Objects.requireNonNull(mc.font);
            guiGraphics.fill(halfWidth - halfLength - 2, minY - 2, halfWidth + halfLength + 2, minY + 9 + 1, Integer.MIN_VALUE);
            FontHelper.drawCenteredFantasy(guiGraphics, mc.font, (Component)Component.literal((String)toDisplay), halfWidth, minY, -8347488);
        }
        if (earnedLevel > 0) {
            halfWidth = mc.getWindow().getGuiScaledWidth() / 2;
            minY = mc.getWindow().getGuiScaledHeight() / 2;
            int newLevel = Optional.ofNullable(mc.player).map(PlayerKnowledgeHandler::getTotalPerkPoints).orElse(0);
            Component message = FontHelper.withFantasyFont((Component)LangKey.MESSAGE_KNOWLEDGE_OF_DEATH.getText(new Object[0]).append((Component)Component.literal((String)(": " + Helper.getRomanNumber(newLevel - earnedLevel) + " -> " + Helper.getRomanNumber(newLevel)))));
            int halfLength = mc.font.width((FormattedText)message) / 2 + 14;
            int halfHeight = 10;
            int a = 255;
            int c = 0;
            if (displayLeftTime >= 90) {
                ratio = TimeHelper.rise(100 - displayLeftTime, 10);
                a = (int)(ratio * 255.0f);
                halfLength = Math.round((float)halfLength * ratio);
                halfHeight = Math.round((float)halfHeight * ratio);
            } else if (displayLeftTime >= 85) {
                ratio = TimeHelper.flicker(89 - displayLeftTime, 5);
                c = (int)(255.0f * ratio);
            } else if (displayLeftTime <= 11) {
                ratio = TimeHelper.downfall(11 - displayLeftTime, 10);
                a = (int)(ratio * 255.0f);
                halfLength = Math.round((float)halfLength * ratio);
                halfHeight = Math.round((float)halfHeight * ratio);
            } else if (displayLeftTime <= 16) {
                ratio = TimeHelper.flicker(16 - displayLeftTime, 5);
                c = (int)(255.0f * ratio);
            }
            GuiGraphics guiGraphics = new GuiGraphics(mc, mc.renderBuffers().bufferSource());
            guiGraphics.fill(halfWidth - halfLength - 2, minY - halfHeight - 2, halfWidth + halfLength + 2, minY + halfHeight + 2, a << 24 | 0xFACA78);
            guiGraphics.fill(halfWidth - halfLength, minY - halfHeight, halfWidth + halfLength, minY + halfHeight, a << 24 | c << 16 | c << 8 | c);
            if (displayLeftTime > 16 && displayLeftTime < 85) {
                int iconHeight = halfHeight * 2;
                int textAlpha = (int)(TimeHelper.flicker(displayLeftTime - 16, 69) * 255.0f);
                Font font = mc.font;
                float f = (float)halfWidth + (float)iconHeight / 2.0f + 2.0f;
                float f2 = (float)minY + 1.0f;
                Objects.requireNonNull(mc.font);
                FontHelper.drawCentered(guiGraphics, font, message, f, f2 - 9.0f / 2.0f, Mth.clamp((int)textAlpha, (int)4, (int)255) << 24 | 0xFACA78);
                RenderSystem.setShaderColor((float)((float)textAlpha / 255.0f), (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.blit(TBScreen.FRAME, halfWidth - halfLength, minY - halfHeight, 0.0f, 0.0f, iconHeight, iconHeight, iconHeight, iconHeight);
                guiGraphics.renderItem(new ItemStack((ItemLike)ModItems.ankh_of_prayer), halfWidth - halfLength + 1, minY - 8);
            }
        }
    }

    public static void showEarnedLevel(int earned) {
        earnedLevel += earned;
        if (displayLeftTime <= 0) {
            displayLeftTime = 100;
        } else if (displayLeftTime < 84) {
            displayLeftTime = 84;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onFieldOfView(ComputeFovModifierEvent event) {
        ItemStack headItem;
        if (!event.getPlayer().isUsingItem() && event.getPlayer().getAbilities().getWalkingSpeed() != 0.0f && ((headItem = event.getPlayer().getItemBySlot(EquipmentSlot.HEAD)).is((Item)ModItems.christmas_hat) || headItem.is((Item)ModItems.rabbit_mask))) {
            event.setNewFovModifier(event.getNewFovModifier() - 0.25f);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onClickAttack(InputEvent.InteractionKeyMappingTriggered event) {
        if (event.isAttack() && event.getHand() == InteractionHand.MAIN_HAND) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.level != null && mc.player != null && mc.player.getMainHandItem().is((Item)ModItems.ankh_of_prayer)) {
                BlockState state;
                BlockHitResult result;
                event.setCanceled(true);
                if (mc.hitResult != null && mc.hitResult.getType() == HitResult.Type.BLOCK && (result = (BlockHitResult)mc.hitResult).distanceTo((Entity)mc.player) < 25.0 && ModBlocks.DECORATIVE_GRAVES.containsValue((state = mc.level.getBlockState(result.getBlockPos())).getBlock()) && mc.level.getGameTime() >= LAST_PACKET + 20L) {
                    LAST_PACKET = mc.level.getGameTime();
                    PacketHandler.sendToServer(new SMessageResetPerk(result.getLocation(), result.getDirection(), result.getBlockPos(), result.isInside()));
                    mc.player.swing(InteractionHand.MAIN_HAND);
                }
                event.setSwingHand(false);
            }
        }
    }

    static {
        earnedLevel = 0;
        displayLeftTime = 0;
        LABEL_SUGGESTION = (ctx, build) -> SharedSuggestionProvider.suggest(Arrays.stream(CompendiumData.CompendiumLabel.values()).map(Enum::name).map(s -> s.toLowerCase(Locale.US)), (SuggestionsBuilder)build);
        LAST_PACKET = 0L;
    }

    private static enum OpeningGui implements ISubCommand
    {
        NONE,
        KNOWLEDGE,
        CONFIG,
        COMPENDIUM;

    }
}

