/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.entity.ai;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.trading.Merchant;
import ovh.corail.tombstone.helper.EntityHelper;

public class TradeWithPlayerGoal<T extends Mob>
extends Goal {
    private final T mob;

    public TradeWithPlayerGoal(T mob) {
        this.mob = mob;
        this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (!this.mob.isAlive() || EntityHelper.targetAnEnemy(this.mob)) {
            return false;
        }
        if (this.mob.isInWater()) {
            return false;
        }
        if (!this.mob.onGround()) {
            return false;
        }
        if (((Mob)this.mob).hurtMarked) {
            return false;
        }
        Player player = ((Merchant)this.mob).getTradingPlayer();
        if (player == null) {
            return false;
        }
        if (this.mob.distanceToSqr((Entity)player) > 16.0) {
            return false;
        }
        return player.containerMenu != null;
    }

    public void start() {
        this.mob.getNavigation().stop();
    }

    public void stop() {
        ((Merchant)this.mob).setTradingPlayer(null);
    }
}

