/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.fluids.FluidType;
import ovh.corail.tombstone.helper.ProxyHelper;

public final class Cloud
extends Entity {
    private static final EntityDataAccessor<Integer> DATA_COLOR = SynchedEntityData.defineId(Cloud.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int lifetime = 6000;

    public Cloud(EntityType<Cloud> cloudType, Level level) {
        super(cloudType, level);
        this.noPhysics = true;
        this.setInvisible(true);
        this.setInvulnerable(true);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_COLOR, (Object)0xFFFFFF);
    }

    public int getColor() {
        return (Integer)this.entityData.get(DATA_COLOR);
    }

    public void setColor(int color) {
        this.entityData.set(DATA_COLOR, (Object)color);
    }

    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
    }

    public void tick() {
        if (this.level().isClientSide) {
            ProxyHelper.produceGraveSmoke(this.level(), 2, this.getX(), this.getY() + 0.4, this.getZ(), this.getColor());
        } else if (this.tickCount >= this.lifetime) {
            this.discard();
        }
    }

    public boolean isAttackable() {
        return false;
    }

    public boolean canChangeDimensions(Level fromLevel, Level toLevel) {
        return false;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    public boolean shouldShowName() {
        return false;
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        if (tag.contains("tick_count", 3)) {
            this.tickCount = tag.getInt("tick_count");
        }
        if (tag.contains("color", 3)) {
            this.setColor(tag.getInt("color"));
        }
        if (tag.contains("lifetime", 3)) {
            this.setLifetime(tag.getInt("lifetime"));
        }
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putInt("tick_count", this.tickCount);
        tag.putInt("color", this.getColor());
        tag.putInt("lifetime", this.lifetime);
    }

    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }
}

